/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.waf.model.WAFResponse;
import software.amazon.awssdk.services.waf.model.XssMatchSetSummariesCopier;
import software.amazon.awssdk.services.waf.model.XssMatchSetSummary;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListXssMatchSetsResponse
extends WAFResponse
implements ToCopyableBuilder<Builder, ListXssMatchSetsResponse> {
    private final String nextMarker;
    private final List<XssMatchSetSummary> xssMatchSets;

    private ListXssMatchSetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.xssMatchSets = builder.xssMatchSets;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public List<XssMatchSetSummary> xssMatchSets() {
        return this.xssMatchSets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.xssMatchSets());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListXssMatchSetsResponse)) {
            return false;
        }
        ListXssMatchSetsResponse other = (ListXssMatchSetsResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && Objects.equals(this.xssMatchSets(), other.xssMatchSets());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (this.xssMatchSets() != null) {
            sb.append("XssMatchSets: ").append(this.xssMatchSets()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.of(clazz.cast(this.nextMarker()));
            }
            case "XssMatchSets": {
                return Optional.of(clazz.cast(this.xssMatchSets()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WAFResponse.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<XssMatchSetSummary> xssMatchSets;

        private BuilderImpl() {
        }

        private BuilderImpl(ListXssMatchSetsResponse model) {
            this.nextMarker(model.nextMarker);
            this.xssMatchSets(model.xssMatchSets);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<XssMatchSetSummary.Builder> getXssMatchSets() {
            return this.xssMatchSets != null ? (Collection)this.xssMatchSets.stream().map(XssMatchSetSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder xssMatchSets(Collection<XssMatchSetSummary> xssMatchSets) {
            this.xssMatchSets = XssMatchSetSummariesCopier.copy(xssMatchSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder xssMatchSets(XssMatchSetSummary ... xssMatchSets) {
            this.xssMatchSets(Arrays.asList(xssMatchSets));
            return this;
        }

        public final void setXssMatchSets(Collection<XssMatchSetSummary.BuilderImpl> xssMatchSets) {
            this.xssMatchSets = XssMatchSetSummariesCopier.copyFromBuilder(xssMatchSets);
        }

        @Override
        public ListXssMatchSetsResponse build() {
            return new ListXssMatchSetsResponse(this);
        }
    }

    public static interface Builder
    extends WAFResponse.Builder,
    CopyableBuilder<Builder, ListXssMatchSetsResponse> {
        public Builder nextMarker(String var1);

        public Builder xssMatchSets(Collection<XssMatchSetSummary> var1);

        public Builder xssMatchSets(XssMatchSetSummary ... var1);
    }
}

