/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.ChangeAction;
import software.amazon.awssdk.services.waf.model.GeoMatchConstraint;
import software.amazon.awssdk.services.waf.transform.GeoMatchSetUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GeoMatchSetUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, GeoMatchSetUpdate> {
    private final String action;
    private final GeoMatchConstraint geoMatchConstraint;

    private GeoMatchSetUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.geoMatchConstraint = builder.geoMatchConstraint;
    }

    public ChangeAction action() {
        return ChangeAction.fromValue(this.action);
    }

    public String actionString() {
        return this.action;
    }

    public GeoMatchConstraint geoMatchConstraint() {
        return this.geoMatchConstraint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.geoMatchConstraint());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoMatchSetUpdate)) {
            return false;
        }
        GeoMatchSetUpdate other = (GeoMatchSetUpdate)obj;
        return Objects.equals(this.actionString(), other.actionString()) && Objects.equals(this.geoMatchConstraint(), other.geoMatchConstraint());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.actionString() != null) {
            sb.append("Action: ").append(this.actionString()).append(",");
        }
        if (this.geoMatchConstraint() != null) {
            sb.append("GeoMatchConstraint: ").append(this.geoMatchConstraint()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.of(clazz.cast(this.actionString()));
            }
            case "GeoMatchConstraint": {
                return Optional.of(clazz.cast(this.geoMatchConstraint()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GeoMatchSetUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private GeoMatchConstraint geoMatchConstraint;

        private BuilderImpl() {
        }

        private BuilderImpl(GeoMatchSetUpdate model) {
            this.action(model.action);
            this.geoMatchConstraint(model.geoMatchConstraint);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final GeoMatchConstraint.Builder getGeoMatchConstraint() {
            return this.geoMatchConstraint != null ? this.geoMatchConstraint.toBuilder() : null;
        }

        @Override
        public final Builder geoMatchConstraint(GeoMatchConstraint geoMatchConstraint) {
            this.geoMatchConstraint = geoMatchConstraint;
            return this;
        }

        public final void setGeoMatchConstraint(GeoMatchConstraint.BuilderImpl geoMatchConstraint) {
            this.geoMatchConstraint = geoMatchConstraint != null ? geoMatchConstraint.build() : null;
        }

        public GeoMatchSetUpdate build() {
            return new GeoMatchSetUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GeoMatchSetUpdate> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder geoMatchConstraint(GeoMatchConstraint var1);

        default public Builder geoMatchConstraint(Consumer<GeoMatchConstraint.Builder> geoMatchConstraint) {
            return this.geoMatchConstraint((GeoMatchConstraint)((GeoMatchConstraint.Builder)GeoMatchConstraint.builder().apply(geoMatchConstraint)).build());
        }
    }
}

