/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.WafAction;
import software.amazon.awssdk.services.waf.model.WafRuleType;
import software.amazon.awssdk.services.waf.transform.ActivatedRuleMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ActivatedRule
implements StructuredPojo,
ToCopyableBuilder<Builder, ActivatedRule> {
    private final Integer priority;
    private final String ruleId;
    private final WafAction action;
    private final String type;

    private ActivatedRule(BuilderImpl builder) {
        this.priority = builder.priority;
        this.ruleId = builder.ruleId;
        this.action = builder.action;
        this.type = builder.type;
    }

    public Integer priority() {
        return this.priority;
    }

    public String ruleId() {
        return this.ruleId;
    }

    public WafAction action() {
        return this.action;
    }

    public WafRuleType type() {
        return WafRuleType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivatedRule)) {
            return false;
        }
        ActivatedRule other = (ActivatedRule)obj;
        return Objects.equals(this.priority(), other.priority()) && Objects.equals(this.ruleId(), other.ruleId()) && Objects.equals(this.action(), other.action()) && Objects.equals(this.typeString(), other.typeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.priority() != null) {
            sb.append("Priority: ").append(this.priority()).append(",");
        }
        if (this.ruleId() != null) {
            sb.append("RuleId: ").append(this.ruleId()).append(",");
        }
        if (this.action() != null) {
            sb.append("Action: ").append(this.action()).append(",");
        }
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Priority": {
                return Optional.of(clazz.cast(this.priority()));
            }
            case "RuleId": {
                return Optional.of(clazz.cast(this.ruleId()));
            }
            case "Action": {
                return Optional.of(clazz.cast(this.action()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActivatedRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer priority;
        private String ruleId;
        private WafAction action;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivatedRule model) {
            this.priority(model.priority);
            this.ruleId(model.ruleId);
            this.action(model.action);
            this.type(model.type);
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        public final WafAction.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        @Override
        public final Builder action(WafAction action) {
            this.action = action;
            return this;
        }

        public final void setAction(WafAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(WafRuleType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public ActivatedRule build() {
            return new ActivatedRule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ActivatedRule> {
        public Builder priority(Integer var1);

        public Builder ruleId(String var1);

        public Builder action(WafAction var1);

        default public Builder action(Consumer<WafAction.Builder> action) {
            return this.action((WafAction)((WafAction.Builder)WafAction.builder().apply(action)).build());
        }

        public Builder type(String var1);

        public Builder type(WafRuleType var1);
    }
}

