/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.waf.model.RateBasedRule;

@SdkInternalApi
public class RateBasedRuleMarshaller {
    private static final MarshallingInfo<String> RULEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RuleId").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> METRICNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MetricName").build();
    private static final MarshallingInfo<List> MATCHPREDICATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MatchPredicates").build();
    private static final MarshallingInfo<String> RATEKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RateKey").build();
    private static final MarshallingInfo<Long> RATELIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RateLimit").build();
    private static final RateBasedRuleMarshaller INSTANCE = new RateBasedRuleMarshaller();

    public static RateBasedRuleMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RateBasedRule rateBasedRule, ProtocolMarshaller protocolMarshaller) {
        if (rateBasedRule == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)rateBasedRule.ruleId(), RULEID_BINDING);
            protocolMarshaller.marshall((Object)rateBasedRule.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)rateBasedRule.metricName(), METRICNAME_BINDING);
            protocolMarshaller.marshall(rateBasedRule.matchPredicates(), MATCHPREDICATES_BINDING);
            protocolMarshaller.marshall((Object)rateBasedRule.rateKeyString(), RATEKEY_BINDING);
            protocolMarshaller.marshall((Object)rateBasedRule.rateLimit(), RATELIMIT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

