/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.waf.model.GeoMatchSet;

@SdkInternalApi
public class GeoMatchSetMarshaller {
    private static final MarshallingInfo<String> GEOMATCHSETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GeoMatchSetId").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<List> GEOMATCHCONSTRAINTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GeoMatchConstraints").build();
    private static final GeoMatchSetMarshaller INSTANCE = new GeoMatchSetMarshaller();

    public static GeoMatchSetMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GeoMatchSet geoMatchSet, ProtocolMarshaller protocolMarshaller) {
        if (geoMatchSet == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)geoMatchSet.geoMatchSetId(), GEOMATCHSETID_BINDING);
            protocolMarshaller.marshall((Object)geoMatchSet.name(), NAME_BINDING);
            protocolMarshaller.marshall(geoMatchSet.geoMatchConstraints(), GEOMATCHCONSTRAINTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

