/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import java.nio.ByteBuffer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.ByteMatchTuple;

@SdkInternalApi
public class ByteMatchTupleMarshaller {
    private static final MarshallingInfo<StructuredPojo> FIELDTOMATCH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FieldToMatch").build();
    private static final MarshallingInfo<ByteBuffer> TARGETSTRING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetString").build();
    private static final MarshallingInfo<String> TEXTTRANSFORMATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TextTransformation").build();
    private static final MarshallingInfo<String> POSITIONALCONSTRAINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PositionalConstraint").build();
    private static final ByteMatchTupleMarshaller INSTANCE = new ByteMatchTupleMarshaller();

    public static ByteMatchTupleMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ByteMatchTuple byteMatchTuple, ProtocolMarshaller protocolMarshaller) {
        if (byteMatchTuple == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)byteMatchTuple.fieldToMatch(), FIELDTOMATCH_BINDING);
            protocolMarshaller.marshall((Object)byteMatchTuple.targetString(), TARGETSTRING_BINDING);
            protocolMarshaller.marshall((Object)byteMatchTuple.textTransformationString(), TEXTTRANSFORMATION_BINDING);
            protocolMarshaller.marshall((Object)byteMatchTuple.positionalConstraintString(), POSITIONALCONSTRAINT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

