/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.waf.model.RuleUpdate;
import software.amazon.awssdk.services.waf.model.RuleUpdatesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateRuleRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateRuleRequest> {
    private final String ruleId;
    private final String changeToken;
    private final List<RuleUpdate> updates;

    private UpdateRuleRequest(BuilderImpl builder) {
        this.ruleId = builder.ruleId;
        this.changeToken = builder.changeToken;
        this.updates = builder.updates;
    }

    public String ruleId() {
        return this.ruleId;
    }

    public String changeToken() {
        return this.changeToken;
    }

    public List<RuleUpdate> updates() {
        return this.updates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.updates());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRuleRequest)) {
            return false;
        }
        UpdateRuleRequest other = (UpdateRuleRequest)((Object)obj);
        return Objects.equals(this.ruleId(), other.ruleId()) && Objects.equals(this.changeToken(), other.changeToken()) && Objects.equals(this.updates(), other.updates());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.ruleId() != null) {
            sb.append("RuleId: ").append(this.ruleId()).append(",");
        }
        if (this.changeToken() != null) {
            sb.append("ChangeToken: ").append(this.changeToken()).append(",");
        }
        if (this.updates() != null) {
            sb.append("Updates: ").append(this.updates()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleId": {
                return Optional.of(clazz.cast(this.ruleId()));
            }
            case "ChangeToken": {
                return Optional.of(clazz.cast(this.changeToken()));
            }
            case "Updates": {
                return Optional.of(clazz.cast(this.updates()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleId;
        private String changeToken;
        private List<RuleUpdate> updates;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRuleRequest model) {
            this.ruleId(model.ruleId);
            this.changeToken(model.changeToken);
            this.updates(model.updates);
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        public final String getChangeToken() {
            return this.changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        public final Collection<RuleUpdate.Builder> getUpdates() {
            return this.updates != null ? (Collection)this.updates.stream().map(RuleUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder updates(Collection<RuleUpdate> updates) {
            this.updates = RuleUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(RuleUpdate ... updates) {
            this.updates(Arrays.asList(updates));
            return this;
        }

        public final void setUpdates(Collection<RuleUpdate.BuilderImpl> updates) {
            this.updates = RuleUpdatesCopier.copyFromBuilder(updates);
        }

        public UpdateRuleRequest build() {
            return new UpdateRuleRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateRuleRequest> {
        public Builder ruleId(String var1);

        public Builder changeToken(String var1);

        public Builder updates(Collection<RuleUpdate> var1);

        public Builder updates(RuleUpdate ... var1);
    }
}

