/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.SizeConstraint;
import software.amazon.awssdk.services.waf.model.SizeConstraintsCopier;
import software.amazon.awssdk.services.waf.transform.SizeConstraintSetMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SizeConstraintSet
implements StructuredPojo,
ToCopyableBuilder<Builder, SizeConstraintSet> {
    private final String sizeConstraintSetId;
    private final String name;
    private final List<SizeConstraint> sizeConstraints;

    private SizeConstraintSet(BuilderImpl builder) {
        this.sizeConstraintSetId = builder.sizeConstraintSetId;
        this.name = builder.name;
        this.sizeConstraints = builder.sizeConstraints;
    }

    public String sizeConstraintSetId() {
        return this.sizeConstraintSetId;
    }

    public String name() {
        return this.name;
    }

    public List<SizeConstraint> sizeConstraints() {
        return this.sizeConstraints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeConstraintSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeConstraints());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SizeConstraintSet)) {
            return false;
        }
        SizeConstraintSet other = (SizeConstraintSet)obj;
        return Objects.equals(this.sizeConstraintSetId(), other.sizeConstraintSetId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.sizeConstraints(), other.sizeConstraints());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.sizeConstraintSetId() != null) {
            sb.append("SizeConstraintSetId: ").append(this.sizeConstraintSetId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.sizeConstraints() != null) {
            sb.append("SizeConstraints: ").append(this.sizeConstraints()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SizeConstraintSetId": {
                return Optional.of(clazz.cast(this.sizeConstraintSetId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "SizeConstraints": {
                return Optional.of(clazz.cast(this.sizeConstraints()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SizeConstraintSetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String sizeConstraintSetId;
        private String name;
        private List<SizeConstraint> sizeConstraints;

        private BuilderImpl() {
        }

        private BuilderImpl(SizeConstraintSet model) {
            this.sizeConstraintSetId(model.sizeConstraintSetId);
            this.name(model.name);
            this.sizeConstraints(model.sizeConstraints);
        }

        public final String getSizeConstraintSetId() {
            return this.sizeConstraintSetId;
        }

        @Override
        public final Builder sizeConstraintSetId(String sizeConstraintSetId) {
            this.sizeConstraintSetId = sizeConstraintSetId;
            return this;
        }

        public final void setSizeConstraintSetId(String sizeConstraintSetId) {
            this.sizeConstraintSetId = sizeConstraintSetId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<SizeConstraint.Builder> getSizeConstraints() {
            return this.sizeConstraints != null ? (Collection)this.sizeConstraints.stream().map(SizeConstraint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sizeConstraints(Collection<SizeConstraint> sizeConstraints) {
            this.sizeConstraints = SizeConstraintsCopier.copy(sizeConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sizeConstraints(SizeConstraint ... sizeConstraints) {
            this.sizeConstraints(Arrays.asList(sizeConstraints));
            return this;
        }

        public final void setSizeConstraints(Collection<SizeConstraint.BuilderImpl> sizeConstraints) {
            this.sizeConstraints = SizeConstraintsCopier.copyFromBuilder(sizeConstraints);
        }

        public SizeConstraintSet build() {
            return new SizeConstraintSet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SizeConstraintSet> {
        public Builder sizeConstraintSetId(String var1);

        public Builder name(String var1);

        public Builder sizeConstraints(Collection<SizeConstraint> var1);

        public Builder sizeConstraints(SizeConstraint ... var1);
    }
}

