/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.waf.model.SqlInjectionMatchSetSummariesCopier;
import software.amazon.awssdk.services.waf.model.SqlInjectionMatchSetSummary;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListSqlInjectionMatchSetsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListSqlInjectionMatchSetsResponse> {
    private final String nextMarker;
    private final List<SqlInjectionMatchSetSummary> sqlInjectionMatchSets;

    private ListSqlInjectionMatchSetsResponse(BuilderImpl builder) {
        this.nextMarker = builder.nextMarker;
        this.sqlInjectionMatchSets = builder.sqlInjectionMatchSets;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public List<SqlInjectionMatchSetSummary> sqlInjectionMatchSets() {
        return this.sqlInjectionMatchSets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        hashCode = 31 * hashCode + (this.sqlInjectionMatchSets() == null ? 0 : this.sqlInjectionMatchSets().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSqlInjectionMatchSetsResponse)) {
            return false;
        }
        ListSqlInjectionMatchSetsResponse other = (ListSqlInjectionMatchSetsResponse)((Object)obj);
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        if (other.nextMarker() != null && !other.nextMarker().equals(this.nextMarker())) {
            return false;
        }
        if (other.sqlInjectionMatchSets() == null ^ this.sqlInjectionMatchSets() == null) {
            return false;
        }
        return other.sqlInjectionMatchSets() == null || other.sqlInjectionMatchSets().equals(this.sqlInjectionMatchSets());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (this.sqlInjectionMatchSets() != null) {
            sb.append("SqlInjectionMatchSets: ").append(this.sqlInjectionMatchSets()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.of(clazz.cast(this.nextMarker()));
            }
            case "SqlInjectionMatchSets": {
                return Optional.of(clazz.cast(this.sqlInjectionMatchSets()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<SqlInjectionMatchSetSummary> sqlInjectionMatchSets;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSqlInjectionMatchSetsResponse model) {
            this.nextMarker(model.nextMarker);
            this.sqlInjectionMatchSets(model.sqlInjectionMatchSets);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<SqlInjectionMatchSetSummary.Builder> getSqlInjectionMatchSets() {
            return this.sqlInjectionMatchSets != null ? (Collection)this.sqlInjectionMatchSets.stream().map(SqlInjectionMatchSetSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sqlInjectionMatchSets(Collection<SqlInjectionMatchSetSummary> sqlInjectionMatchSets) {
            this.sqlInjectionMatchSets = SqlInjectionMatchSetSummariesCopier.copy(sqlInjectionMatchSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sqlInjectionMatchSets(SqlInjectionMatchSetSummary ... sqlInjectionMatchSets) {
            this.sqlInjectionMatchSets(Arrays.asList(sqlInjectionMatchSets));
            return this;
        }

        public final void setSqlInjectionMatchSets(Collection<SqlInjectionMatchSetSummary.BuilderImpl> sqlInjectionMatchSets) {
            this.sqlInjectionMatchSets = SqlInjectionMatchSetSummariesCopier.copyFromBuilder(sqlInjectionMatchSets);
        }

        public ListSqlInjectionMatchSetsResponse build() {
            return new ListSqlInjectionMatchSetsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListSqlInjectionMatchSetsResponse> {
        public Builder nextMarker(String var1);

        public Builder sqlInjectionMatchSets(Collection<SqlInjectionMatchSetSummary> var1);

        public Builder sqlInjectionMatchSets(SqlInjectionMatchSetSummary ... var1);
    }
}

