/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.waf.model.ManagedKeysCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetRateBasedRuleManagedKeysResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetRateBasedRuleManagedKeysResponse> {
    private final List<String> managedKeys;
    private final String nextMarker;

    private GetRateBasedRuleManagedKeysResponse(BuilderImpl builder) {
        this.managedKeys = builder.managedKeys;
        this.nextMarker = builder.nextMarker;
    }

    public List<String> managedKeys() {
        return this.managedKeys;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.managedKeys() == null ? 0 : this.managedKeys().hashCode());
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRateBasedRuleManagedKeysResponse)) {
            return false;
        }
        GetRateBasedRuleManagedKeysResponse other = (GetRateBasedRuleManagedKeysResponse)((Object)obj);
        if (other.managedKeys() == null ^ this.managedKeys() == null) {
            return false;
        }
        if (other.managedKeys() != null && !other.managedKeys().equals(this.managedKeys())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        return other.nextMarker() == null || other.nextMarker().equals(this.nextMarker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.managedKeys() != null) {
            sb.append("ManagedKeys: ").append(this.managedKeys()).append(",");
        }
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ManagedKeys": {
                return Optional.of(clazz.cast(this.managedKeys()));
            }
            case "NextMarker": {
                return Optional.of(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> managedKeys;
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRateBasedRuleManagedKeysResponse model) {
            this.managedKeys(model.managedKeys);
            this.nextMarker(model.nextMarker);
        }

        public final Collection<String> getManagedKeys() {
            return this.managedKeys;
        }

        @Override
        public final Builder managedKeys(Collection<String> managedKeys) {
            this.managedKeys = ManagedKeysCopier.copy(managedKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedKeys(String ... managedKeys) {
            this.managedKeys(Arrays.asList(managedKeys));
            return this;
        }

        public final void setManagedKeys(Collection<String> managedKeys) {
            this.managedKeys = ManagedKeysCopier.copy(managedKeys);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public GetRateBasedRuleManagedKeysResponse build() {
            return new GetRateBasedRuleManagedKeysResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetRateBasedRuleManagedKeysResponse> {
        public Builder managedKeys(Collection<String> var1);

        public Builder managedKeys(String ... var1);

        public Builder nextMarker(String var1);
    }
}

