/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.WebACLUpdate;

@SdkInternalApi
public class WebACLUpdateMarshaller {
    private static final MarshallingInfo<String> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Action").build();
    private static final MarshallingInfo<StructuredPojo> ACTIVATEDRULE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActivatedRule").build();
    private static final WebACLUpdateMarshaller INSTANCE = new WebACLUpdateMarshaller();

    public static WebACLUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(WebACLUpdate webACLUpdate, ProtocolMarshaller protocolMarshaller) {
        if (webACLUpdate == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)webACLUpdate.action(), ACTION_BINDING);
            protocolMarshaller.marshall((Object)webACLUpdate.activatedRule(), ACTIVATEDRULE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

