/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.waf.model.SizeConstraintSetUpdate;
import software.amazon.awssdk.services.waf.model.SizeConstraintSetUpdatesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateSizeConstraintSetRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateSizeConstraintSetRequest> {
    private final String sizeConstraintSetId;
    private final String changeToken;
    private final List<SizeConstraintSetUpdate> updates;

    private UpdateSizeConstraintSetRequest(BuilderImpl builder) {
        this.sizeConstraintSetId = builder.sizeConstraintSetId;
        this.changeToken = builder.changeToken;
        this.updates = builder.updates;
    }

    public String sizeConstraintSetId() {
        return this.sizeConstraintSetId;
    }

    public String changeToken() {
        return this.changeToken;
    }

    public List<SizeConstraintSetUpdate> updates() {
        return this.updates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sizeConstraintSetId() == null ? 0 : this.sizeConstraintSetId().hashCode());
        hashCode = 31 * hashCode + (this.changeToken() == null ? 0 : this.changeToken().hashCode());
        hashCode = 31 * hashCode + (this.updates() == null ? 0 : this.updates().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSizeConstraintSetRequest)) {
            return false;
        }
        UpdateSizeConstraintSetRequest other = (UpdateSizeConstraintSetRequest)((Object)obj);
        if (other.sizeConstraintSetId() == null ^ this.sizeConstraintSetId() == null) {
            return false;
        }
        if (other.sizeConstraintSetId() != null && !other.sizeConstraintSetId().equals(this.sizeConstraintSetId())) {
            return false;
        }
        if (other.changeToken() == null ^ this.changeToken() == null) {
            return false;
        }
        if (other.changeToken() != null && !other.changeToken().equals(this.changeToken())) {
            return false;
        }
        if (other.updates() == null ^ this.updates() == null) {
            return false;
        }
        return other.updates() == null || other.updates().equals(this.updates());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sizeConstraintSetId() != null) {
            sb.append("SizeConstraintSetId: ").append(this.sizeConstraintSetId()).append(",");
        }
        if (this.changeToken() != null) {
            sb.append("ChangeToken: ").append(this.changeToken()).append(",");
        }
        if (this.updates() != null) {
            sb.append("Updates: ").append(this.updates()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String sizeConstraintSetId;
        private String changeToken;
        private List<SizeConstraintSetUpdate> updates;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSizeConstraintSetRequest model) {
            this.setSizeConstraintSetId(model.sizeConstraintSetId);
            this.setChangeToken(model.changeToken);
            this.setUpdates(model.updates);
        }

        public final String getSizeConstraintSetId() {
            return this.sizeConstraintSetId;
        }

        @Override
        public final Builder sizeConstraintSetId(String sizeConstraintSetId) {
            this.sizeConstraintSetId = sizeConstraintSetId;
            return this;
        }

        public final void setSizeConstraintSetId(String sizeConstraintSetId) {
            this.sizeConstraintSetId = sizeConstraintSetId;
        }

        public final String getChangeToken() {
            return this.changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        public final Collection<SizeConstraintSetUpdate> getUpdates() {
            return this.updates;
        }

        @Override
        public final Builder updates(Collection<SizeConstraintSetUpdate> updates) {
            this.updates = SizeConstraintSetUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(SizeConstraintSetUpdate ... updates) {
            this.updates(Arrays.asList(updates));
            return this;
        }

        public final void setUpdates(Collection<SizeConstraintSetUpdate> updates) {
            this.updates = SizeConstraintSetUpdatesCopier.copy(updates);
        }

        public UpdateSizeConstraintSetRequest build() {
            return new UpdateSizeConstraintSetRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateSizeConstraintSetRequest> {
        public Builder sizeConstraintSetId(String var1);

        public Builder changeToken(String var1);

        public Builder updates(Collection<SizeConstraintSetUpdate> var1);

        public Builder updates(SizeConstraintSetUpdate ... var1);
    }
}

