/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.PredicateType;
import software.amazon.awssdk.services.waf.transform.PredicateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Predicate
implements StructuredPojo,
ToCopyableBuilder<Builder, Predicate> {
    private final Boolean negated;
    private final String type;
    private final String dataId;

    private Predicate(BuilderImpl builder) {
        this.negated = builder.negated;
        this.type = builder.type;
        this.dataId = builder.dataId;
    }

    public Boolean negated() {
        return this.negated;
    }

    public String type() {
        return this.type;
    }

    public String dataId() {
        return this.dataId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.negated() == null ? 0 : this.negated().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.dataId() == null ? 0 : this.dataId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Predicate)) {
            return false;
        }
        Predicate other = (Predicate)obj;
        if (other.negated() == null ^ this.negated() == null) {
            return false;
        }
        if (other.negated() != null && !other.negated().equals(this.negated())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.dataId() == null ^ this.dataId() == null) {
            return false;
        }
        return other.dataId() == null || other.dataId().equals(this.dataId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.negated() != null) {
            sb.append("Negated: ").append(this.negated()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.dataId() != null) {
            sb.append("DataId: ").append(this.dataId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PredicateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Boolean negated;
        private String type;
        private String dataId;

        private BuilderImpl() {
        }

        private BuilderImpl(Predicate model) {
            this.setNegated(model.negated);
            this.setType(model.type);
            this.setDataId(model.dataId);
        }

        public final Boolean getNegated() {
            return this.negated;
        }

        @Override
        public final Builder negated(Boolean negated) {
            this.negated = negated;
            return this;
        }

        public final void setNegated(Boolean negated) {
            this.negated = negated;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PredicateType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getDataId() {
            return this.dataId;
        }

        @Override
        public final Builder dataId(String dataId) {
            this.dataId = dataId;
            return this;
        }

        public final void setDataId(String dataId) {
            this.dataId = dataId;
        }

        public Predicate build() {
            return new Predicate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Predicate> {
        public Builder negated(Boolean var1);

        public Builder type(String var1);

        public Builder type(PredicateType var1);

        public Builder dataId(String var1);
    }
}

