/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.waf.model.ByteMatchSet;

@SdkInternalApi
public class ByteMatchSetMarshaller {
    private static final MarshallingInfo<String> BYTEMATCHSETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ByteMatchSetId").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<List> BYTEMATCHTUPLES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ByteMatchTuples").build();
    private static final ByteMatchSetMarshaller instance = new ByteMatchSetMarshaller();

    public static ByteMatchSetMarshaller getInstance() {
        return instance;
    }

    public void marshall(ByteMatchSet byteMatchSet, ProtocolMarshaller protocolMarshaller) {
        if (byteMatchSet == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)byteMatchSet.byteMatchSetId(), BYTEMATCHSETID_BINDING);
            protocolMarshaller.marshall((Object)byteMatchSet.name(), NAME_BINDING);
            protocolMarshaller.marshall(byteMatchSet.byteMatchTuples(), BYTEMATCHTUPLES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

