/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.waf.model.RuleUpdate;
import software.amazon.awssdk.services.waf.model.RuleUpdatesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateRateBasedRuleRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateRateBasedRuleRequest> {
    private final String ruleId;
    private final String changeToken;
    private final List<RuleUpdate> updates;
    private final Long rateLimit;

    private UpdateRateBasedRuleRequest(BuilderImpl builder) {
        this.ruleId = builder.ruleId;
        this.changeToken = builder.changeToken;
        this.updates = builder.updates;
        this.rateLimit = builder.rateLimit;
    }

    public String ruleId() {
        return this.ruleId;
    }

    public String changeToken() {
        return this.changeToken;
    }

    public List<RuleUpdate> updates() {
        return this.updates;
    }

    public Long rateLimit() {
        return this.rateLimit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ruleId() == null ? 0 : this.ruleId().hashCode());
        hashCode = 31 * hashCode + (this.changeToken() == null ? 0 : this.changeToken().hashCode());
        hashCode = 31 * hashCode + (this.updates() == null ? 0 : this.updates().hashCode());
        hashCode = 31 * hashCode + (this.rateLimit() == null ? 0 : this.rateLimit().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRateBasedRuleRequest)) {
            return false;
        }
        UpdateRateBasedRuleRequest other = (UpdateRateBasedRuleRequest)((Object)obj);
        if (other.ruleId() == null ^ this.ruleId() == null) {
            return false;
        }
        if (other.ruleId() != null && !other.ruleId().equals(this.ruleId())) {
            return false;
        }
        if (other.changeToken() == null ^ this.changeToken() == null) {
            return false;
        }
        if (other.changeToken() != null && !other.changeToken().equals(this.changeToken())) {
            return false;
        }
        if (other.updates() == null ^ this.updates() == null) {
            return false;
        }
        if (other.updates() != null && !other.updates().equals(this.updates())) {
            return false;
        }
        if (other.rateLimit() == null ^ this.rateLimit() == null) {
            return false;
        }
        return other.rateLimit() == null || other.rateLimit().equals(this.rateLimit());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ruleId() != null) {
            sb.append("RuleId: ").append(this.ruleId()).append(",");
        }
        if (this.changeToken() != null) {
            sb.append("ChangeToken: ").append(this.changeToken()).append(",");
        }
        if (this.updates() != null) {
            sb.append("Updates: ").append(this.updates()).append(",");
        }
        if (this.rateLimit() != null) {
            sb.append("RateLimit: ").append(this.rateLimit()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String ruleId;
        private String changeToken;
        private List<RuleUpdate> updates;
        private Long rateLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRateBasedRuleRequest model) {
            this.setRuleId(model.ruleId);
            this.setChangeToken(model.changeToken);
            this.setUpdates(model.updates);
            this.setRateLimit(model.rateLimit);
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        public final String getChangeToken() {
            return this.changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        public final Collection<RuleUpdate> getUpdates() {
            return this.updates;
        }

        @Override
        public final Builder updates(Collection<RuleUpdate> updates) {
            this.updates = RuleUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(RuleUpdate ... updates) {
            this.updates(Arrays.asList(updates));
            return this;
        }

        public final void setUpdates(Collection<RuleUpdate> updates) {
            this.updates = RuleUpdatesCopier.copy(updates);
        }

        @SafeVarargs
        public final void setUpdates(RuleUpdate ... updates) {
            this.updates(Arrays.asList(updates));
        }

        public final Long getRateLimit() {
            return this.rateLimit;
        }

        @Override
        public final Builder rateLimit(Long rateLimit) {
            this.rateLimit = rateLimit;
            return this;
        }

        public final void setRateLimit(Long rateLimit) {
            this.rateLimit = rateLimit;
        }

        public UpdateRateBasedRuleRequest build() {
            return new UpdateRateBasedRuleRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateRateBasedRuleRequest> {
        public Builder ruleId(String var1);

        public Builder changeToken(String var1);

        public Builder updates(Collection<RuleUpdate> var1);

        public Builder updates(RuleUpdate ... var1);

        public Builder rateLimit(Long var1);
    }
}

