/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.waf.model.IPSetUpdate;
import software.amazon.awssdk.services.waf.model.IPSetUpdatesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateIPSetRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateIPSetRequest> {
    private final String ipSetId;
    private final String changeToken;
    private final List<IPSetUpdate> updates;

    private UpdateIPSetRequest(BuilderImpl builder) {
        this.ipSetId = builder.ipSetId;
        this.changeToken = builder.changeToken;
        this.updates = builder.updates;
    }

    public String ipSetId() {
        return this.ipSetId;
    }

    public String changeToken() {
        return this.changeToken;
    }

    public List<IPSetUpdate> updates() {
        return this.updates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ipSetId() == null ? 0 : this.ipSetId().hashCode());
        hashCode = 31 * hashCode + (this.changeToken() == null ? 0 : this.changeToken().hashCode());
        hashCode = 31 * hashCode + (this.updates() == null ? 0 : this.updates().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIPSetRequest)) {
            return false;
        }
        UpdateIPSetRequest other = (UpdateIPSetRequest)((Object)obj);
        if (other.ipSetId() == null ^ this.ipSetId() == null) {
            return false;
        }
        if (other.ipSetId() != null && !other.ipSetId().equals(this.ipSetId())) {
            return false;
        }
        if (other.changeToken() == null ^ this.changeToken() == null) {
            return false;
        }
        if (other.changeToken() != null && !other.changeToken().equals(this.changeToken())) {
            return false;
        }
        if (other.updates() == null ^ this.updates() == null) {
            return false;
        }
        return other.updates() == null || other.updates().equals(this.updates());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ipSetId() != null) {
            sb.append("IPSetId: ").append(this.ipSetId()).append(",");
        }
        if (this.changeToken() != null) {
            sb.append("ChangeToken: ").append(this.changeToken()).append(",");
        }
        if (this.updates() != null) {
            sb.append("Updates: ").append(this.updates()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String ipSetId;
        private String changeToken;
        private List<IPSetUpdate> updates;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIPSetRequest model) {
            this.setIPSetId(model.ipSetId);
            this.setChangeToken(model.changeToken);
            this.setUpdates(model.updates);
        }

        public final String getIPSetId() {
            return this.ipSetId;
        }

        @Override
        public final Builder ipSetId(String ipSetId) {
            this.ipSetId = ipSetId;
            return this;
        }

        public final void setIPSetId(String ipSetId) {
            this.ipSetId = ipSetId;
        }

        public final String getChangeToken() {
            return this.changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        public final Collection<IPSetUpdate> getUpdates() {
            return this.updates;
        }

        @Override
        public final Builder updates(Collection<IPSetUpdate> updates) {
            this.updates = IPSetUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(IPSetUpdate ... updates) {
            this.updates(Arrays.asList(updates));
            return this;
        }

        public final void setUpdates(Collection<IPSetUpdate> updates) {
            this.updates = IPSetUpdatesCopier.copy(updates);
        }

        @SafeVarargs
        public final void setUpdates(IPSetUpdate ... updates) {
            this.updates(Arrays.asList(updates));
        }

        public UpdateIPSetRequest build() {
            return new UpdateIPSetRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateIPSetRequest> {
        public Builder ipSetId(String var1);

        public Builder changeToken(String var1);

        public Builder updates(Collection<IPSetUpdate> var1);

        public Builder updates(IPSetUpdate ... var1);
    }
}

