/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.stream.Stream;
import software.amazon.awssdk.util.StringUtils;

public enum TextTransformation {
    NONE("NONE"),
    COMPRESS_WHITE_SPACE("COMPRESS_WHITE_SPACE"),
    HTML_ENTITY_DECODE("HTML_ENTITY_DECODE"),
    LOWERCASE("LOWERCASE"),
    CMD_LINE("CMD_LINE"),
    URL_DECODE("URL_DECODE");

    private final String value;

    private TextTransformation(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static TextTransformation fromValue(String value) {
        if (StringUtils.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(TextTransformation.values()).filter(e -> e.toString().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}

