/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.Predicate;
import software.amazon.awssdk.services.waf.model.PredicatesCopier;
import software.amazon.awssdk.services.waf.model.RateKey;
import software.amazon.awssdk.services.waf.transform.RateBasedRuleMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RateBasedRule
implements StructuredPojo,
ToCopyableBuilder<Builder, RateBasedRule> {
    private final String ruleId;
    private final String name;
    private final String metricName;
    private final List<Predicate> matchPredicates;
    private final String rateKey;
    private final Long rateLimit;

    private RateBasedRule(BuilderImpl builder) {
        this.ruleId = builder.ruleId;
        this.name = builder.name;
        this.metricName = builder.metricName;
        this.matchPredicates = builder.matchPredicates;
        this.rateKey = builder.rateKey;
        this.rateLimit = builder.rateLimit;
    }

    public String ruleId() {
        return this.ruleId;
    }

    public String name() {
        return this.name;
    }

    public String metricName() {
        return this.metricName;
    }

    public List<Predicate> matchPredicates() {
        return this.matchPredicates;
    }

    public String rateKey() {
        return this.rateKey;
    }

    public Long rateLimit() {
        return this.rateLimit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ruleId() == null ? 0 : this.ruleId().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.metricName() == null ? 0 : this.metricName().hashCode());
        hashCode = 31 * hashCode + (this.matchPredicates() == null ? 0 : this.matchPredicates().hashCode());
        hashCode = 31 * hashCode + (this.rateKey() == null ? 0 : this.rateKey().hashCode());
        hashCode = 31 * hashCode + (this.rateLimit() == null ? 0 : this.rateLimit().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RateBasedRule)) {
            return false;
        }
        RateBasedRule other = (RateBasedRule)obj;
        if (other.ruleId() == null ^ this.ruleId() == null) {
            return false;
        }
        if (other.ruleId() != null && !other.ruleId().equals(this.ruleId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.metricName() == null ^ this.metricName() == null) {
            return false;
        }
        if (other.metricName() != null && !other.metricName().equals(this.metricName())) {
            return false;
        }
        if (other.matchPredicates() == null ^ this.matchPredicates() == null) {
            return false;
        }
        if (other.matchPredicates() != null && !other.matchPredicates().equals(this.matchPredicates())) {
            return false;
        }
        if (other.rateKey() == null ^ this.rateKey() == null) {
            return false;
        }
        if (other.rateKey() != null && !other.rateKey().equals(this.rateKey())) {
            return false;
        }
        if (other.rateLimit() == null ^ this.rateLimit() == null) {
            return false;
        }
        return other.rateLimit() == null || other.rateLimit().equals(this.rateLimit());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ruleId() != null) {
            sb.append("RuleId: ").append(this.ruleId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.metricName() != null) {
            sb.append("MetricName: ").append(this.metricName()).append(",");
        }
        if (this.matchPredicates() != null) {
            sb.append("MatchPredicates: ").append(this.matchPredicates()).append(",");
        }
        if (this.rateKey() != null) {
            sb.append("RateKey: ").append(this.rateKey()).append(",");
        }
        if (this.rateLimit() != null) {
            sb.append("RateLimit: ").append(this.rateLimit()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RateBasedRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String ruleId;
        private String name;
        private String metricName;
        private List<Predicate> matchPredicates;
        private String rateKey;
        private Long rateLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(RateBasedRule model) {
            this.setRuleId(model.ruleId);
            this.setName(model.name);
            this.setMetricName(model.metricName);
            this.setMatchPredicates(model.matchPredicates);
            this.setRateKey(model.rateKey);
            this.setRateLimit(model.rateLimit);
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final Collection<Predicate> getMatchPredicates() {
            return this.matchPredicates;
        }

        @Override
        public final Builder matchPredicates(Collection<Predicate> matchPredicates) {
            this.matchPredicates = PredicatesCopier.copy(matchPredicates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchPredicates(Predicate ... matchPredicates) {
            this.matchPredicates(Arrays.asList(matchPredicates));
            return this;
        }

        public final void setMatchPredicates(Collection<Predicate> matchPredicates) {
            this.matchPredicates = PredicatesCopier.copy(matchPredicates);
        }

        @SafeVarargs
        public final void setMatchPredicates(Predicate ... matchPredicates) {
            this.matchPredicates(Arrays.asList(matchPredicates));
        }

        public final String getRateKey() {
            return this.rateKey;
        }

        @Override
        public final Builder rateKey(String rateKey) {
            this.rateKey = rateKey;
            return this;
        }

        @Override
        public final Builder rateKey(RateKey rateKey) {
            this.rateKey(rateKey.toString());
            return this;
        }

        public final void setRateKey(String rateKey) {
            this.rateKey = rateKey;
        }

        public final void setRateKey(RateKey rateKey) {
            this.rateKey(rateKey.toString());
        }

        public final Long getRateLimit() {
            return this.rateLimit;
        }

        @Override
        public final Builder rateLimit(Long rateLimit) {
            this.rateLimit = rateLimit;
            return this;
        }

        public final void setRateLimit(Long rateLimit) {
            this.rateLimit = rateLimit;
        }

        public RateBasedRule build() {
            return new RateBasedRule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RateBasedRule> {
        public Builder ruleId(String var1);

        public Builder name(String var1);

        public Builder metricName(String var1);

        public Builder matchPredicates(Collection<Predicate> var1);

        public Builder matchPredicates(Predicate ... var1);

        public Builder rateKey(String var1);

        public Builder rateKey(RateKey var1);

        public Builder rateLimit(Long var1);
    }
}

