/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.waf.model.SizeConstraintSetSummariesCopier;
import software.amazon.awssdk.services.waf.model.SizeConstraintSetSummary;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListSizeConstraintSetsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListSizeConstraintSetsResponse> {
    private final String nextMarker;
    private final List<SizeConstraintSetSummary> sizeConstraintSets;

    private ListSizeConstraintSetsResponse(BuilderImpl builder) {
        this.nextMarker = builder.nextMarker;
        this.sizeConstraintSets = builder.sizeConstraintSets;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public List<SizeConstraintSetSummary> sizeConstraintSets() {
        return this.sizeConstraintSets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        hashCode = 31 * hashCode + (this.sizeConstraintSets() == null ? 0 : this.sizeConstraintSets().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSizeConstraintSetsResponse)) {
            return false;
        }
        ListSizeConstraintSetsResponse other = (ListSizeConstraintSetsResponse)((Object)obj);
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        if (other.nextMarker() != null && !other.nextMarker().equals(this.nextMarker())) {
            return false;
        }
        if (other.sizeConstraintSets() == null ^ this.sizeConstraintSets() == null) {
            return false;
        }
        return other.sizeConstraintSets() == null || other.sizeConstraintSets().equals(this.sizeConstraintSets());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (this.sizeConstraintSets() != null) {
            sb.append("SizeConstraintSets: ").append(this.sizeConstraintSets()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<SizeConstraintSetSummary> sizeConstraintSets;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSizeConstraintSetsResponse model) {
            this.setNextMarker(model.nextMarker);
            this.setSizeConstraintSets(model.sizeConstraintSets);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<SizeConstraintSetSummary> getSizeConstraintSets() {
            return this.sizeConstraintSets;
        }

        @Override
        public final Builder sizeConstraintSets(Collection<SizeConstraintSetSummary> sizeConstraintSets) {
            this.sizeConstraintSets = SizeConstraintSetSummariesCopier.copy(sizeConstraintSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sizeConstraintSets(SizeConstraintSetSummary ... sizeConstraintSets) {
            this.sizeConstraintSets(Arrays.asList(sizeConstraintSets));
            return this;
        }

        public final void setSizeConstraintSets(Collection<SizeConstraintSetSummary> sizeConstraintSets) {
            this.sizeConstraintSets = SizeConstraintSetSummariesCopier.copy(sizeConstraintSets);
        }

        @SafeVarargs
        public final void setSizeConstraintSets(SizeConstraintSetSummary ... sizeConstraintSets) {
            this.sizeConstraintSets(Arrays.asList(sizeConstraintSets));
        }

        public ListSizeConstraintSetsResponse build() {
            return new ListSizeConstraintSetsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListSizeConstraintSetsResponse> {
        public Builder nextMarker(String var1);

        public Builder sizeConstraintSets(Collection<SizeConstraintSetSummary> var1);

        public Builder sizeConstraintSets(SizeConstraintSetSummary ... var1);
    }
}

