/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.ChangeAction;
import software.amazon.awssdk.services.waf.model.IPSetDescriptor;
import software.amazon.awssdk.services.waf.transform.IPSetUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class IPSetUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, IPSetUpdate> {
    private final String action;
    private final IPSetDescriptor ipSetDescriptor;

    private IPSetUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.ipSetDescriptor = builder.ipSetDescriptor;
    }

    public String action() {
        return this.action;
    }

    public IPSetDescriptor ipSetDescriptor() {
        return this.ipSetDescriptor;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.action() == null ? 0 : this.action().hashCode());
        hashCode = 31 * hashCode + (this.ipSetDescriptor() == null ? 0 : this.ipSetDescriptor().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPSetUpdate)) {
            return false;
        }
        IPSetUpdate other = (IPSetUpdate)obj;
        if (other.action() == null ^ this.action() == null) {
            return false;
        }
        if (other.action() != null && !other.action().equals(this.action())) {
            return false;
        }
        if (other.ipSetDescriptor() == null ^ this.ipSetDescriptor() == null) {
            return false;
        }
        return other.ipSetDescriptor() == null || other.ipSetDescriptor().equals(this.ipSetDescriptor());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.action() != null) {
            sb.append("Action: ").append(this.action()).append(",");
        }
        if (this.ipSetDescriptor() != null) {
            sb.append("IPSetDescriptor: ").append(this.ipSetDescriptor()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IPSetUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String action;
        private IPSetDescriptor ipSetDescriptor;

        private BuilderImpl() {
        }

        private BuilderImpl(IPSetUpdate model) {
            this.setAction(model.action);
            this.setIPSetDescriptor(model.ipSetDescriptor);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final void setAction(ChangeAction action) {
            this.action(action.toString());
        }

        public final IPSetDescriptor getIPSetDescriptor() {
            return this.ipSetDescriptor;
        }

        @Override
        public final Builder ipSetDescriptor(IPSetDescriptor ipSetDescriptor) {
            this.ipSetDescriptor = ipSetDescriptor;
            return this;
        }

        public final void setIPSetDescriptor(IPSetDescriptor ipSetDescriptor) {
            this.ipSetDescriptor = ipSetDescriptor;
        }

        public IPSetUpdate build() {
            return new IPSetUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IPSetUpdate> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder ipSetDescriptor(IPSetDescriptor var1);
    }
}

