/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.nio.ByteBuffer;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.waf.model.FieldToMatch;
import software.amazon.awssdk.services.waf.model.PositionalConstraint;
import software.amazon.awssdk.services.waf.model.TextTransformation;
import software.amazon.awssdk.services.waf.transform.ByteMatchTupleMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ByteMatchTuple
implements StructuredPojo,
ToCopyableBuilder<Builder, ByteMatchTuple> {
    private final FieldToMatch fieldToMatch;
    private final ByteBuffer targetString;
    private final String textTransformation;
    private final String positionalConstraint;

    private ByteMatchTuple(BuilderImpl builder) {
        this.fieldToMatch = builder.fieldToMatch;
        this.targetString = builder.targetString;
        this.textTransformation = builder.textTransformation;
        this.positionalConstraint = builder.positionalConstraint;
    }

    public FieldToMatch fieldToMatch() {
        return this.fieldToMatch;
    }

    public ByteBuffer targetString() {
        return this.targetString == null ? null : this.targetString.asReadOnlyBuffer();
    }

    public String textTransformation() {
        return this.textTransformation;
    }

    public String positionalConstraint() {
        return this.positionalConstraint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.fieldToMatch() == null ? 0 : this.fieldToMatch().hashCode());
        hashCode = 31 * hashCode + (this.targetString() == null ? 0 : this.targetString().hashCode());
        hashCode = 31 * hashCode + (this.textTransformation() == null ? 0 : this.textTransformation().hashCode());
        hashCode = 31 * hashCode + (this.positionalConstraint() == null ? 0 : this.positionalConstraint().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ByteMatchTuple)) {
            return false;
        }
        ByteMatchTuple other = (ByteMatchTuple)obj;
        if (other.fieldToMatch() == null ^ this.fieldToMatch() == null) {
            return false;
        }
        if (other.fieldToMatch() != null && !other.fieldToMatch().equals(this.fieldToMatch())) {
            return false;
        }
        if (other.targetString() == null ^ this.targetString() == null) {
            return false;
        }
        if (other.targetString() != null && !other.targetString().equals(this.targetString())) {
            return false;
        }
        if (other.textTransformation() == null ^ this.textTransformation() == null) {
            return false;
        }
        if (other.textTransformation() != null && !other.textTransformation().equals(this.textTransformation())) {
            return false;
        }
        if (other.positionalConstraint() == null ^ this.positionalConstraint() == null) {
            return false;
        }
        return other.positionalConstraint() == null || other.positionalConstraint().equals(this.positionalConstraint());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fieldToMatch() != null) {
            sb.append("FieldToMatch: ").append(this.fieldToMatch()).append(",");
        }
        if (this.targetString() != null) {
            sb.append("TargetString: ").append(this.targetString()).append(",");
        }
        if (this.textTransformation() != null) {
            sb.append("TextTransformation: ").append(this.textTransformation()).append(",");
        }
        if (this.positionalConstraint() != null) {
            sb.append("PositionalConstraint: ").append(this.positionalConstraint()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ByteMatchTupleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private FieldToMatch fieldToMatch;
        private ByteBuffer targetString;
        private String textTransformation;
        private String positionalConstraint;

        private BuilderImpl() {
        }

        private BuilderImpl(ByteMatchTuple model) {
            this.setFieldToMatch(model.fieldToMatch);
            this.setTargetString(model.targetString);
            this.setTextTransformation(model.textTransformation);
            this.setPositionalConstraint(model.positionalConstraint);
        }

        public final FieldToMatch getFieldToMatch() {
            return this.fieldToMatch;
        }

        @Override
        public final Builder fieldToMatch(FieldToMatch fieldToMatch) {
            this.fieldToMatch = fieldToMatch;
            return this;
        }

        public final void setFieldToMatch(FieldToMatch fieldToMatch) {
            this.fieldToMatch = fieldToMatch;
        }

        public final ByteBuffer getTargetString() {
            return this.targetString;
        }

        @Override
        public final Builder targetString(ByteBuffer targetString) {
            this.targetString = StandardMemberCopier.copy((ByteBuffer)targetString);
            return this;
        }

        public final void setTargetString(ByteBuffer targetString) {
            this.targetString = StandardMemberCopier.copy((ByteBuffer)targetString);
        }

        public final String getTextTransformation() {
            return this.textTransformation;
        }

        @Override
        public final Builder textTransformation(String textTransformation) {
            this.textTransformation = textTransformation;
            return this;
        }

        @Override
        public final Builder textTransformation(TextTransformation textTransformation) {
            this.textTransformation(textTransformation.toString());
            return this;
        }

        public final void setTextTransformation(String textTransformation) {
            this.textTransformation = textTransformation;
        }

        public final void setTextTransformation(TextTransformation textTransformation) {
            this.textTransformation(textTransformation.toString());
        }

        public final String getPositionalConstraint() {
            return this.positionalConstraint;
        }

        @Override
        public final Builder positionalConstraint(String positionalConstraint) {
            this.positionalConstraint = positionalConstraint;
            return this;
        }

        @Override
        public final Builder positionalConstraint(PositionalConstraint positionalConstraint) {
            this.positionalConstraint(positionalConstraint.toString());
            return this;
        }

        public final void setPositionalConstraint(String positionalConstraint) {
            this.positionalConstraint = positionalConstraint;
        }

        public final void setPositionalConstraint(PositionalConstraint positionalConstraint) {
            this.positionalConstraint(positionalConstraint.toString());
        }

        public ByteMatchTuple build() {
            return new ByteMatchTuple(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ByteMatchTuple> {
        public Builder fieldToMatch(FieldToMatch var1);

        public Builder targetString(ByteBuffer var1);

        public Builder textTransformation(String var1);

        public Builder textTransformation(TextTransformation var1);

        public Builder positionalConstraint(String var1);

        public Builder positionalConstraint(PositionalConstraint var1);
    }
}

