/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.UpdateWebAclRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateWebAclRequestModelMarshaller {
    private static final MarshallingInfo<String> WEBACLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WebACLId").isBinary(false).build();
    private static final MarshallingInfo<String> CHANGETOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChangeToken").isBinary(false).build();
    private static final MarshallingInfo<List> UPDATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Updates").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DEFAULTACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultAction").isBinary(false).build();
    private static final UpdateWebAclRequestModelMarshaller INSTANCE = new UpdateWebAclRequestModelMarshaller();

    private UpdateWebAclRequestModelMarshaller() {
    }

    public static UpdateWebAclRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateWebAclRequest updateWebAclRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateWebAclRequest), (String)"updateWebAclRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateWebAclRequest.webACLId(), WEBACLID_BINDING);
            protocolMarshaller.marshall((Object)updateWebAclRequest.changeToken(), CHANGETOKEN_BINDING);
            protocolMarshaller.marshall(updateWebAclRequest.updates(), UPDATES_BINDING);
            protocolMarshaller.marshall((Object)updateWebAclRequest.defaultAction(), DEFAULTACTION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

