/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.waf.model.ByteMatchSet;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ByteMatchSetMarshaller {
    private static final MarshallingInfo<String> BYTEMATCHSETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ByteMatchSetId").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<List> BYTEMATCHTUPLES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ByteMatchTuples").isBinary(false).build();
    private static final ByteMatchSetMarshaller INSTANCE = new ByteMatchSetMarshaller();

    private ByteMatchSetMarshaller() {
    }

    public static ByteMatchSetMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ByteMatchSet byteMatchSet, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)byteMatchSet, (String)"byteMatchSet");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)byteMatchSet.byteMatchSetId(), BYTEMATCHSETID_BINDING);
            protocolMarshaller.marshall((Object)byteMatchSet.name(), NAME_BINDING);
            protocolMarshaller.marshall(byteMatchSet.byteMatchTuples(), BYTEMATCHTUPLES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

