/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.RuleUpdate;
import software.amazon.awssdk.services.waf.model.RuleUpdatesCopier;
import software.amazon.awssdk.services.waf.model.WafRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRateBasedRuleRequest
extends WafRequest
implements ToCopyableBuilder<Builder, UpdateRateBasedRuleRequest> {
    private final String ruleId;
    private final String changeToken;
    private final List<RuleUpdate> updates;
    private final Long rateLimit;

    private UpdateRateBasedRuleRequest(BuilderImpl builder) {
        super(builder);
        this.ruleId = builder.ruleId;
        this.changeToken = builder.changeToken;
        this.updates = builder.updates;
        this.rateLimit = builder.rateLimit;
    }

    public String ruleId() {
        return this.ruleId;
    }

    public String changeToken() {
        return this.changeToken;
    }

    public List<RuleUpdate> updates() {
        return this.updates;
    }

    public Long rateLimit() {
        return this.rateLimit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.updates());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateLimit());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRateBasedRuleRequest)) {
            return false;
        }
        UpdateRateBasedRuleRequest other = (UpdateRateBasedRuleRequest)((Object)obj);
        return Objects.equals(this.ruleId(), other.ruleId()) && Objects.equals(this.changeToken(), other.changeToken()) && Objects.equals(this.updates(), other.updates()) && Objects.equals(this.rateLimit(), other.rateLimit());
    }

    public String toString() {
        return ToString.builder((String)"UpdateRateBasedRuleRequest").add("RuleId", (Object)this.ruleId()).add("ChangeToken", (Object)this.changeToken()).add("Updates", this.updates()).add("RateLimit", (Object)this.rateLimit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleId": {
                return Optional.ofNullable(clazz.cast(this.ruleId()));
            }
            case "ChangeToken": {
                return Optional.ofNullable(clazz.cast(this.changeToken()));
            }
            case "Updates": {
                return Optional.ofNullable(clazz.cast(this.updates()));
            }
            case "RateLimit": {
                return Optional.ofNullable(clazz.cast(this.rateLimit()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WafRequest.BuilderImpl
    implements Builder {
        private String ruleId;
        private String changeToken;
        private List<RuleUpdate> updates = DefaultSdkAutoConstructList.getInstance();
        private Long rateLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRateBasedRuleRequest model) {
            super(model);
            this.ruleId(model.ruleId);
            this.changeToken(model.changeToken);
            this.updates(model.updates);
            this.rateLimit(model.rateLimit);
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        public final String getChangeToken() {
            return this.changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        public final Collection<RuleUpdate.Builder> getUpdates() {
            return this.updates != null ? (Collection)this.updates.stream().map(RuleUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder updates(Collection<RuleUpdate> updates) {
            this.updates = RuleUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(RuleUpdate ... updates) {
            this.updates(Arrays.asList(updates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(Consumer<RuleUpdate.Builder> ... updates) {
            this.updates(Stream.of(updates).map(c -> (RuleUpdate)((RuleUpdate.Builder)RuleUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUpdates(Collection<RuleUpdate.BuilderImpl> updates) {
            this.updates = RuleUpdatesCopier.copyFromBuilder(updates);
        }

        public final Long getRateLimit() {
            return this.rateLimit;
        }

        @Override
        public final Builder rateLimit(Long rateLimit) {
            this.rateLimit = rateLimit;
            return this;
        }

        public final void setRateLimit(Long rateLimit) {
            this.rateLimit = rateLimit;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRateBasedRuleRequest build() {
            return new UpdateRateBasedRuleRequest(this);
        }
    }

    public static interface Builder
    extends WafRequest.Builder,
    CopyableBuilder<Builder, UpdateRateBasedRuleRequest> {
        public Builder ruleId(String var1);

        public Builder changeToken(String var1);

        public Builder updates(Collection<RuleUpdate> var1);

        public Builder updates(RuleUpdate ... var1);

        public Builder updates(Consumer<RuleUpdate.Builder> ... var1);

        public Builder rateLimit(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

