/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.ByteMatchSetUpdate;
import software.amazon.awssdk.services.waf.model.ByteMatchSetUpdatesCopier;
import software.amazon.awssdk.services.waf.model.WafRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateByteMatchSetRequest
extends WafRequest
implements ToCopyableBuilder<Builder, UpdateByteMatchSetRequest> {
    private final String byteMatchSetId;
    private final String changeToken;
    private final List<ByteMatchSetUpdate> updates;

    private UpdateByteMatchSetRequest(BuilderImpl builder) {
        super(builder);
        this.byteMatchSetId = builder.byteMatchSetId;
        this.changeToken = builder.changeToken;
        this.updates = builder.updates;
    }

    public String byteMatchSetId() {
        return this.byteMatchSetId;
    }

    public String changeToken() {
        return this.changeToken;
    }

    public List<ByteMatchSetUpdate> updates() {
        return this.updates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.byteMatchSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.updates());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateByteMatchSetRequest)) {
            return false;
        }
        UpdateByteMatchSetRequest other = (UpdateByteMatchSetRequest)((Object)obj);
        return Objects.equals(this.byteMatchSetId(), other.byteMatchSetId()) && Objects.equals(this.changeToken(), other.changeToken()) && Objects.equals(this.updates(), other.updates());
    }

    public String toString() {
        return ToString.builder((String)"UpdateByteMatchSetRequest").add("ByteMatchSetId", (Object)this.byteMatchSetId()).add("ChangeToken", (Object)this.changeToken()).add("Updates", this.updates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ByteMatchSetId": {
                return Optional.ofNullable(clazz.cast(this.byteMatchSetId()));
            }
            case "ChangeToken": {
                return Optional.ofNullable(clazz.cast(this.changeToken()));
            }
            case "Updates": {
                return Optional.ofNullable(clazz.cast(this.updates()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WafRequest.BuilderImpl
    implements Builder {
        private String byteMatchSetId;
        private String changeToken;
        private List<ByteMatchSetUpdate> updates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateByteMatchSetRequest model) {
            super(model);
            this.byteMatchSetId(model.byteMatchSetId);
            this.changeToken(model.changeToken);
            this.updates(model.updates);
        }

        public final String getByteMatchSetId() {
            return this.byteMatchSetId;
        }

        @Override
        public final Builder byteMatchSetId(String byteMatchSetId) {
            this.byteMatchSetId = byteMatchSetId;
            return this;
        }

        public final void setByteMatchSetId(String byteMatchSetId) {
            this.byteMatchSetId = byteMatchSetId;
        }

        public final String getChangeToken() {
            return this.changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        public final Collection<ByteMatchSetUpdate.Builder> getUpdates() {
            return this.updates != null ? (Collection)this.updates.stream().map(ByteMatchSetUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder updates(Collection<ByteMatchSetUpdate> updates) {
            this.updates = ByteMatchSetUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(ByteMatchSetUpdate ... updates) {
            this.updates(Arrays.asList(updates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(Consumer<ByteMatchSetUpdate.Builder> ... updates) {
            this.updates(Stream.of(updates).map(c -> (ByteMatchSetUpdate)((ByteMatchSetUpdate.Builder)ByteMatchSetUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUpdates(Collection<ByteMatchSetUpdate.BuilderImpl> updates) {
            this.updates = ByteMatchSetUpdatesCopier.copyFromBuilder(updates);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateByteMatchSetRequest build() {
            return new UpdateByteMatchSetRequest(this);
        }
    }

    public static interface Builder
    extends WafRequest.Builder,
    CopyableBuilder<Builder, UpdateByteMatchSetRequest> {
        public Builder byteMatchSetId(String var1);

        public Builder changeToken(String var1);

        public Builder updates(Collection<ByteMatchSetUpdate> var1);

        public Builder updates(ByteMatchSetUpdate ... var1);

        public Builder updates(Consumer<ByteMatchSetUpdate.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

