/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.ManagedKeysCopier;
import software.amazon.awssdk.services.waf.model.WafResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRateBasedRuleManagedKeysResponse
extends WafResponse
implements ToCopyableBuilder<Builder, GetRateBasedRuleManagedKeysResponse> {
    private final List<String> managedKeys;
    private final String nextMarker;

    private GetRateBasedRuleManagedKeysResponse(BuilderImpl builder) {
        super(builder);
        this.managedKeys = builder.managedKeys;
        this.nextMarker = builder.nextMarker;
    }

    public List<String> managedKeys() {
        return this.managedKeys;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.managedKeys());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRateBasedRuleManagedKeysResponse)) {
            return false;
        }
        GetRateBasedRuleManagedKeysResponse other = (GetRateBasedRuleManagedKeysResponse)((Object)obj);
        return Objects.equals(this.managedKeys(), other.managedKeys()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public String toString() {
        return ToString.builder((String)"GetRateBasedRuleManagedKeysResponse").add("ManagedKeys", this.managedKeys()).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ManagedKeys": {
                return Optional.ofNullable(clazz.cast(this.managedKeys()));
            }
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WafResponse.BuilderImpl
    implements Builder {
        private List<String> managedKeys = DefaultSdkAutoConstructList.getInstance();
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRateBasedRuleManagedKeysResponse model) {
            super(model);
            this.managedKeys(model.managedKeys);
            this.nextMarker(model.nextMarker);
        }

        public final Collection<String> getManagedKeys() {
            return this.managedKeys;
        }

        @Override
        public final Builder managedKeys(Collection<String> managedKeys) {
            this.managedKeys = ManagedKeysCopier.copy(managedKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedKeys(String ... managedKeys) {
            this.managedKeys(Arrays.asList(managedKeys));
            return this;
        }

        public final void setManagedKeys(Collection<String> managedKeys) {
            this.managedKeys = ManagedKeysCopier.copy(managedKeys);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public GetRateBasedRuleManagedKeysResponse build() {
            return new GetRateBasedRuleManagedKeysResponse(this);
        }
    }

    public static interface Builder
    extends WafResponse.Builder,
    CopyableBuilder<Builder, GetRateBasedRuleManagedKeysResponse> {
        public Builder managedKeys(Collection<String> var1);

        public Builder managedKeys(String ... var1);

        public Builder nextMarker(String var1);
    }
}

