/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.FieldToMatch;
import software.amazon.awssdk.services.waf.model.PositionalConstraint;
import software.amazon.awssdk.services.waf.model.TextTransformation;
import software.amazon.awssdk.services.waf.transform.ByteMatchTupleMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ByteMatchTuple
implements StructuredPojo,
ToCopyableBuilder<Builder, ByteMatchTuple> {
    private final FieldToMatch fieldToMatch;
    private final SdkBytes targetString;
    private final String textTransformation;
    private final String positionalConstraint;

    private ByteMatchTuple(BuilderImpl builder) {
        this.fieldToMatch = builder.fieldToMatch;
        this.targetString = builder.targetString;
        this.textTransformation = builder.textTransformation;
        this.positionalConstraint = builder.positionalConstraint;
    }

    public FieldToMatch fieldToMatch() {
        return this.fieldToMatch;
    }

    public SdkBytes targetString() {
        return this.targetString;
    }

    public TextTransformation textTransformation() {
        return TextTransformation.fromValue(this.textTransformation);
    }

    public String textTransformationAsString() {
        return this.textTransformation;
    }

    public PositionalConstraint positionalConstraint() {
        return PositionalConstraint.fromValue(this.positionalConstraint);
    }

    public String positionalConstraintAsString() {
        return this.positionalConstraint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldToMatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetString());
        hashCode = 31 * hashCode + Objects.hashCode(this.textTransformationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.positionalConstraintAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ByteMatchTuple)) {
            return false;
        }
        ByteMatchTuple other = (ByteMatchTuple)obj;
        return Objects.equals(this.fieldToMatch(), other.fieldToMatch()) && Objects.equals(this.targetString(), other.targetString()) && Objects.equals(this.textTransformationAsString(), other.textTransformationAsString()) && Objects.equals(this.positionalConstraintAsString(), other.positionalConstraintAsString());
    }

    public String toString() {
        return ToString.builder((String)"ByteMatchTuple").add("FieldToMatch", (Object)this.fieldToMatch()).add("TargetString", (Object)this.targetString()).add("TextTransformation", (Object)this.textTransformationAsString()).add("PositionalConstraint", (Object)this.positionalConstraintAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldToMatch": {
                return Optional.ofNullable(clazz.cast(this.fieldToMatch()));
            }
            case "TargetString": {
                return Optional.ofNullable(clazz.cast(this.targetString()));
            }
            case "TextTransformation": {
                return Optional.ofNullable(clazz.cast(this.textTransformationAsString()));
            }
            case "PositionalConstraint": {
                return Optional.ofNullable(clazz.cast(this.positionalConstraintAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ByteMatchTupleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private FieldToMatch fieldToMatch;
        private SdkBytes targetString;
        private String textTransformation;
        private String positionalConstraint;

        private BuilderImpl() {
        }

        private BuilderImpl(ByteMatchTuple model) {
            this.fieldToMatch(model.fieldToMatch);
            this.targetString(model.targetString);
            this.textTransformation(model.textTransformation);
            this.positionalConstraint(model.positionalConstraint);
        }

        public final FieldToMatch.Builder getFieldToMatch() {
            return this.fieldToMatch != null ? this.fieldToMatch.toBuilder() : null;
        }

        @Override
        public final Builder fieldToMatch(FieldToMatch fieldToMatch) {
            this.fieldToMatch = fieldToMatch;
            return this;
        }

        public final void setFieldToMatch(FieldToMatch.BuilderImpl fieldToMatch) {
            this.fieldToMatch = fieldToMatch != null ? fieldToMatch.build() : null;
        }

        public final ByteBuffer getTargetString() {
            return this.targetString == null ? null : this.targetString.asByteBuffer();
        }

        @Override
        public final Builder targetString(SdkBytes targetString) {
            this.targetString = StandardMemberCopier.copy((SdkBytes)targetString);
            return this;
        }

        public final void setTargetString(ByteBuffer targetString) {
            this.targetString(targetString == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)targetString));
        }

        public final String getTextTransformation() {
            return this.textTransformation;
        }

        @Override
        public final Builder textTransformation(String textTransformation) {
            this.textTransformation = textTransformation;
            return this;
        }

        @Override
        public final Builder textTransformation(TextTransformation textTransformation) {
            this.textTransformation(textTransformation.toString());
            return this;
        }

        public final void setTextTransformation(String textTransformation) {
            this.textTransformation = textTransformation;
        }

        public final String getPositionalConstraint() {
            return this.positionalConstraint;
        }

        @Override
        public final Builder positionalConstraint(String positionalConstraint) {
            this.positionalConstraint = positionalConstraint;
            return this;
        }

        @Override
        public final Builder positionalConstraint(PositionalConstraint positionalConstraint) {
            this.positionalConstraint(positionalConstraint.toString());
            return this;
        }

        public final void setPositionalConstraint(String positionalConstraint) {
            this.positionalConstraint = positionalConstraint;
        }

        public ByteMatchTuple build() {
            return new ByteMatchTuple(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ByteMatchTuple> {
        public Builder fieldToMatch(FieldToMatch var1);

        default public Builder fieldToMatch(Consumer<FieldToMatch.Builder> fieldToMatch) {
            return this.fieldToMatch((FieldToMatch)((FieldToMatch.Builder)FieldToMatch.builder().applyMutation(fieldToMatch)).build());
        }

        public Builder targetString(SdkBytes var1);

        public Builder textTransformation(String var1);

        public Builder textTransformation(TextTransformation var1);

        public Builder positionalConstraint(String var1);

        public Builder positionalConstraint(PositionalConstraint var1);
    }
}

