/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.waf.model.XssMatchSet;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class XssMatchSetMarshaller {
    private static final MarshallingInfo<String> XSSMATCHSETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("XssMatchSetId").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<List> XSSMATCHTUPLES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("XssMatchTuples").isBinary(false).build();
    private static final XssMatchSetMarshaller INSTANCE = new XssMatchSetMarshaller();

    private XssMatchSetMarshaller() {
    }

    public static XssMatchSetMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(XssMatchSet xssMatchSet, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)xssMatchSet, (String)"xssMatchSet");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)xssMatchSet.xssMatchSetId(), XSSMATCHSETID_BINDING);
            protocolMarshaller.marshall((Object)xssMatchSet.name(), NAME_BINDING);
            protocolMarshaller.marshall(xssMatchSet.xssMatchTuples(), XSSMATCHTUPLES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

