/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.waf.model.WebACLSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class WebACLSummaryMarshaller {
    private static final MarshallingInfo<String> WEBACLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WebACLId").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final WebACLSummaryMarshaller INSTANCE = new WebACLSummaryMarshaller();

    private WebACLSummaryMarshaller() {
    }

    public static WebACLSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(WebACLSummary webACLSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)webACLSummary, (String)"webACLSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)webACLSummary.webACLId(), WEBACLID_BINDING);
            protocolMarshaller.marshall((Object)webACLSummary.name(), NAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

