/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.waf.model.Rule;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RuleMarshaller {
    private static final MarshallingInfo<String> RULEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RuleId").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> METRICNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MetricName").isBinary(false).build();
    private static final MarshallingInfo<List> PREDICATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Predicates").isBinary(false).build();
    private static final RuleMarshaller INSTANCE = new RuleMarshaller();

    private RuleMarshaller() {
    }

    public static RuleMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Rule rule, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)rule, (String)"rule");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)rule.ruleId(), RULEID_BINDING);
            protocolMarshaller.marshall((Object)rule.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)rule.metricName(), METRICNAME_BINDING);
            protocolMarshaller.marshall(rule.predicates(), PREDICATES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

