/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.RegexPatternSetUpdate;
import software.amazon.awssdk.services.waf.model.RegexPatternSetUpdatesCopier;
import software.amazon.awssdk.services.waf.model.WafRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRegexPatternSetRequest
extends WafRequest
implements ToCopyableBuilder<Builder, UpdateRegexPatternSetRequest> {
    private final String regexPatternSetId;
    private final List<RegexPatternSetUpdate> updates;
    private final String changeToken;

    private UpdateRegexPatternSetRequest(BuilderImpl builder) {
        super(builder);
        this.regexPatternSetId = builder.regexPatternSetId;
        this.updates = builder.updates;
        this.changeToken = builder.changeToken;
    }

    public String regexPatternSetId() {
        return this.regexPatternSetId;
    }

    public List<RegexPatternSetUpdate> updates() {
        return this.updates;
    }

    public String changeToken() {
        return this.changeToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.regexPatternSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.updates());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRegexPatternSetRequest)) {
            return false;
        }
        UpdateRegexPatternSetRequest other = (UpdateRegexPatternSetRequest)((Object)obj);
        return Objects.equals(this.regexPatternSetId(), other.regexPatternSetId()) && Objects.equals(this.updates(), other.updates()) && Objects.equals(this.changeToken(), other.changeToken());
    }

    public String toString() {
        return ToString.builder((String)"UpdateRegexPatternSetRequest").add("RegexPatternSetId", (Object)this.regexPatternSetId()).add("Updates", this.updates()).add("ChangeToken", (Object)this.changeToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegexPatternSetId": {
                return Optional.ofNullable(clazz.cast(this.regexPatternSetId()));
            }
            case "Updates": {
                return Optional.ofNullable(clazz.cast(this.updates()));
            }
            case "ChangeToken": {
                return Optional.ofNullable(clazz.cast(this.changeToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WafRequest.BuilderImpl
    implements Builder {
        private String regexPatternSetId;
        private List<RegexPatternSetUpdate> updates = DefaultSdkAutoConstructList.getInstance();
        private String changeToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRegexPatternSetRequest model) {
            super(model);
            this.regexPatternSetId(model.regexPatternSetId);
            this.updates(model.updates);
            this.changeToken(model.changeToken);
        }

        public final String getRegexPatternSetId() {
            return this.regexPatternSetId;
        }

        @Override
        public final Builder regexPatternSetId(String regexPatternSetId) {
            this.regexPatternSetId = regexPatternSetId;
            return this;
        }

        public final void setRegexPatternSetId(String regexPatternSetId) {
            this.regexPatternSetId = regexPatternSetId;
        }

        public final Collection<RegexPatternSetUpdate.Builder> getUpdates() {
            return this.updates != null ? (Collection)this.updates.stream().map(RegexPatternSetUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder updates(Collection<RegexPatternSetUpdate> updates) {
            this.updates = RegexPatternSetUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(RegexPatternSetUpdate ... updates) {
            this.updates(Arrays.asList(updates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(Consumer<RegexPatternSetUpdate.Builder> ... updates) {
            this.updates(Stream.of(updates).map(c -> (RegexPatternSetUpdate)((RegexPatternSetUpdate.Builder)RegexPatternSetUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUpdates(Collection<RegexPatternSetUpdate.BuilderImpl> updates) {
            this.updates = RegexPatternSetUpdatesCopier.copyFromBuilder(updates);
        }

        public final String getChangeToken() {
            return this.changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRegexPatternSetRequest build() {
            return new UpdateRegexPatternSetRequest(this);
        }
    }

    public static interface Builder
    extends WafRequest.Builder,
    CopyableBuilder<Builder, UpdateRegexPatternSetRequest> {
        public Builder regexPatternSetId(String var1);

        public Builder updates(Collection<RegexPatternSetUpdate> var1);

        public Builder updates(RegexPatternSetUpdate ... var1);

        public Builder updates(Consumer<RegexPatternSetUpdate.Builder> ... var1);

        public Builder changeToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

