/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.waf.model.WafRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateWebAclRequest
extends WafRequest
implements ToCopyableBuilder<Builder, AssociateWebAclRequest> {
    private final String webACLId;
    private final String resourceArn;

    private AssociateWebAclRequest(BuilderImpl builder) {
        super(builder);
        this.webACLId = builder.webACLId;
        this.resourceArn = builder.resourceArn;
    }

    public String webACLId() {
        return this.webACLId;
    }

    public String resourceArn() {
        return this.resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.webACLId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateWebAclRequest)) {
            return false;
        }
        AssociateWebAclRequest other = (AssociateWebAclRequest)((Object)obj);
        return Objects.equals(this.webACLId(), other.webACLId()) && Objects.equals(this.resourceArn(), other.resourceArn());
    }

    public String toString() {
        return ToString.builder((String)"AssociateWebAclRequest").add("WebACLId", (Object)this.webACLId()).add("ResourceArn", (Object)this.resourceArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WebACLId": {
                return Optional.ofNullable(clazz.cast(this.webACLId()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WafRequest.BuilderImpl
    implements Builder {
        private String webACLId;
        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateWebAclRequest model) {
            super(model);
            this.webACLId(model.webACLId);
            this.resourceArn(model.resourceArn);
        }

        public final String getWebACLId() {
            return this.webACLId;
        }

        @Override
        public final Builder webACLId(String webACLId) {
            this.webACLId = webACLId;
            return this;
        }

        public final void setWebACLId(String webACLId) {
            this.webACLId = webACLId;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateWebAclRequest build() {
            return new AssociateWebAclRequest(this);
        }
    }

    public static interface Builder
    extends WafRequest.Builder,
    CopyableBuilder<Builder, AssociateWebAclRequest> {
        public Builder webACLId(String var1);

        public Builder resourceArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

