/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafregional.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.waf.model.DeleteWebACLRequest;
import software.amazon.awssdk.services.waf.transform.DeleteWebACLRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeleteWebACLRequestMarshaller
implements Marshaller<Request<DeleteWebACLRequest>, DeleteWebACLRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("AWSWAF_Regional_20161128.DeleteWebACL").serviceName("WAF Regional").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public DeleteWebACLRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DeleteWebACLRequest> marshall(DeleteWebACLRequest deleteWebACLRequest) {
        Validate.paramNotNull((Object)((Object)deleteWebACLRequest), (String)"deleteWebACLRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)deleteWebACLRequest);
            protocolMarshaller.startMarshalling();
            DeleteWebACLRequestModelMarshaller.getInstance().marshall(deleteWebACLRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

