/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.UpdateWebACLRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateWebACLRequestModelMarshaller {
    private static final MarshallingInfo<String> WEBACLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WebACLId").isBinary(false).build();
    private static final MarshallingInfo<String> CHANGETOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChangeToken").isBinary(false).build();
    private static final MarshallingInfo<List> UPDATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Updates").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DEFAULTACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultAction").isBinary(false).build();
    private static final UpdateWebACLRequestModelMarshaller INSTANCE = new UpdateWebACLRequestModelMarshaller();

    private UpdateWebACLRequestModelMarshaller() {
    }

    public static UpdateWebACLRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateWebACLRequest updateWebACLRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateWebACLRequest), (String)"updateWebACLRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateWebACLRequest.webACLId(), WEBACLID_BINDING);
            protocolMarshaller.marshall((Object)updateWebACLRequest.changeToken(), CHANGETOKEN_BINDING);
            protocolMarshaller.marshall(updateWebACLRequest.updates(), UPDATES_BINDING);
            protocolMarshaller.marshall((Object)updateWebACLRequest.defaultAction(), DEFAULTACTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

