/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.waf.model.SqlInjectionMatchSet;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SqlInjectionMatchSetMarshaller {
    private static final MarshallingInfo<String> SQLINJECTIONMATCHSETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SqlInjectionMatchSetId").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<List> SQLINJECTIONMATCHTUPLES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SqlInjectionMatchTuples").isBinary(false).build();
    private static final SqlInjectionMatchSetMarshaller INSTANCE = new SqlInjectionMatchSetMarshaller();

    private SqlInjectionMatchSetMarshaller() {
    }

    public static SqlInjectionMatchSetMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SqlInjectionMatchSet sqlInjectionMatchSet, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)sqlInjectionMatchSet, (String)"sqlInjectionMatchSet");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)sqlInjectionMatchSet.sqlInjectionMatchSetId(), SQLINJECTIONMATCHSETID_BINDING);
            protocolMarshaller.marshall((Object)sqlInjectionMatchSet.name(), NAME_BINDING);
            protocolMarshaller.marshall(sqlInjectionMatchSet.sqlInjectionMatchTuples(), SQLINJECTIONMATCHTUPLES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

