/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.RuleUpdate;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RuleUpdateMarshaller {
    private static final MarshallingInfo<String> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Action").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PREDICATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Predicate").isBinary(false).build();
    private static final RuleUpdateMarshaller INSTANCE = new RuleUpdateMarshaller();

    private RuleUpdateMarshaller() {
    }

    public static RuleUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RuleUpdate ruleUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)ruleUpdate, (String)"ruleUpdate");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)ruleUpdate.actionAsString(), ACTION_BINDING);
            protocolMarshaller.marshall((Object)ruleUpdate.predicate(), PREDICATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

