/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.RegexMatchTuple;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RegexMatchTupleMarshaller {
    private static final MarshallingInfo<StructuredPojo> FIELDTOMATCH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FieldToMatch").isBinary(false).build();
    private static final MarshallingInfo<String> TEXTTRANSFORMATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TextTransformation").isBinary(false).build();
    private static final MarshallingInfo<String> REGEXPATTERNSETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegexPatternSetId").isBinary(false).build();
    private static final RegexMatchTupleMarshaller INSTANCE = new RegexMatchTupleMarshaller();

    private RegexMatchTupleMarshaller() {
    }

    public static RegexMatchTupleMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RegexMatchTuple regexMatchTuple, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)regexMatchTuple, (String)"regexMatchTuple");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)regexMatchTuple.fieldToMatch(), FIELDTOMATCH_BINDING);
            protocolMarshaller.marshall((Object)regexMatchTuple.textTransformationAsString(), TEXTTRANSFORMATION_BINDING);
            protocolMarshaller.marshall((Object)regexMatchTuple.regexPatternSetId(), REGEXPATTERNSETID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

