/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.waf.model.RegexMatchSet;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RegexMatchSetMarshaller {
    private static final MarshallingInfo<String> REGEXMATCHSETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegexMatchSetId").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<List> REGEXMATCHTUPLES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegexMatchTuples").isBinary(false).build();
    private static final RegexMatchSetMarshaller INSTANCE = new RegexMatchSetMarshaller();

    private RegexMatchSetMarshaller() {
    }

    public static RegexMatchSetMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RegexMatchSet regexMatchSet, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)regexMatchSet, (String)"regexMatchSet");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)regexMatchSet.regexMatchSetId(), REGEXMATCHSETID_BINDING);
            protocolMarshaller.marshall((Object)regexMatchSet.name(), NAME_BINDING);
            protocolMarshaller.marshall(regexMatchSet.regexMatchTuples(), REGEXMATCHTUPLES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

