/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.ByteMatchSetUpdate;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ByteMatchSetUpdateMarshaller {
    private static final MarshallingInfo<String> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Action").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> BYTEMATCHTUPLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ByteMatchTuple").isBinary(false).build();
    private static final ByteMatchSetUpdateMarshaller INSTANCE = new ByteMatchSetUpdateMarshaller();

    private ByteMatchSetUpdateMarshaller() {
    }

    public static ByteMatchSetUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ByteMatchSetUpdate byteMatchSetUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)byteMatchSetUpdate, (String)"byteMatchSetUpdate");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)byteMatchSetUpdate.actionAsString(), ACTION_BINDING);
            protocolMarshaller.marshall((Object)byteMatchSetUpdate.byteMatchTuple(), BYTEMATCHTUPLE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

