/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.waf.model.AssociateWebACLRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AssociateWebACLRequestModelMarshaller {
    private static final MarshallingInfo<String> WEBACLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WebACLId").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceArn").isBinary(false).build();
    private static final AssociateWebACLRequestModelMarshaller INSTANCE = new AssociateWebACLRequestModelMarshaller();

    private AssociateWebACLRequestModelMarshaller() {
    }

    public static AssociateWebACLRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AssociateWebACLRequest associateWebACLRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)associateWebACLRequest), (String)"associateWebACLRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)associateWebACLRequest.webACLId(), WEBACLID_BINDING);
            protocolMarshaller.marshall((Object)associateWebACLRequest.resourceArn(), RESOURCEARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

