/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.XssMatchTuple;
import software.amazon.awssdk.services.waf.model.XssMatchTuplesCopier;
import software.amazon.awssdk.services.waf.transform.XssMatchSetMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class XssMatchSet
implements StructuredPojo,
ToCopyableBuilder<Builder, XssMatchSet> {
    private final String xssMatchSetId;
    private final String name;
    private final List<XssMatchTuple> xssMatchTuples;

    private XssMatchSet(BuilderImpl builder) {
        this.xssMatchSetId = builder.xssMatchSetId;
        this.name = builder.name;
        this.xssMatchTuples = builder.xssMatchTuples;
    }

    public String xssMatchSetId() {
        return this.xssMatchSetId;
    }

    public String name() {
        return this.name;
    }

    public List<XssMatchTuple> xssMatchTuples() {
        return this.xssMatchTuples;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.xssMatchSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.xssMatchTuples());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof XssMatchSet)) {
            return false;
        }
        XssMatchSet other = (XssMatchSet)obj;
        return Objects.equals(this.xssMatchSetId(), other.xssMatchSetId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.xssMatchTuples(), other.xssMatchTuples());
    }

    public String toString() {
        return ToString.builder((String)"XssMatchSet").add("XssMatchSetId", (Object)this.xssMatchSetId()).add("Name", (Object)this.name()).add("XssMatchTuples", this.xssMatchTuples()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "XssMatchSetId": {
                return Optional.of(clazz.cast(this.xssMatchSetId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "XssMatchTuples": {
                return Optional.of(clazz.cast(this.xssMatchTuples()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        XssMatchSetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String xssMatchSetId;
        private String name;
        private List<XssMatchTuple> xssMatchTuples;

        private BuilderImpl() {
        }

        private BuilderImpl(XssMatchSet model) {
            this.xssMatchSetId(model.xssMatchSetId);
            this.name(model.name);
            this.xssMatchTuples(model.xssMatchTuples);
        }

        public final String getXssMatchSetId() {
            return this.xssMatchSetId;
        }

        @Override
        public final Builder xssMatchSetId(String xssMatchSetId) {
            this.xssMatchSetId = xssMatchSetId;
            return this;
        }

        public final void setXssMatchSetId(String xssMatchSetId) {
            this.xssMatchSetId = xssMatchSetId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<XssMatchTuple.Builder> getXssMatchTuples() {
            return this.xssMatchTuples != null ? (Collection)this.xssMatchTuples.stream().map(XssMatchTuple::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder xssMatchTuples(Collection<XssMatchTuple> xssMatchTuples) {
            this.xssMatchTuples = XssMatchTuplesCopier.copy(xssMatchTuples);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder xssMatchTuples(XssMatchTuple ... xssMatchTuples) {
            this.xssMatchTuples(Arrays.asList(xssMatchTuples));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder xssMatchTuples(Consumer<XssMatchTuple.Builder> ... xssMatchTuples) {
            this.xssMatchTuples(Stream.of(xssMatchTuples).map(c -> (XssMatchTuple)((XssMatchTuple.Builder)XssMatchTuple.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setXssMatchTuples(Collection<XssMatchTuple.BuilderImpl> xssMatchTuples) {
            this.xssMatchTuples = XssMatchTuplesCopier.copyFromBuilder(xssMatchTuples);
        }

        public XssMatchSet build() {
            return new XssMatchSet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, XssMatchSet> {
        public Builder xssMatchSetId(String var1);

        public Builder name(String var1);

        public Builder xssMatchTuples(Collection<XssMatchTuple> var1);

        public Builder xssMatchTuples(XssMatchTuple ... var1);

        public Builder xssMatchTuples(Consumer<XssMatchTuple.Builder> ... var1);
    }
}

