/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.waf.model.WAFRequest;
import software.amazon.awssdk.services.waf.model.XssMatchSetUpdate;
import software.amazon.awssdk.services.waf.model.XssMatchSetUpdatesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateXssMatchSetRequest
extends WAFRequest
implements ToCopyableBuilder<Builder, UpdateXssMatchSetRequest> {
    private final String xssMatchSetId;
    private final String changeToken;
    private final List<XssMatchSetUpdate> updates;

    private UpdateXssMatchSetRequest(BuilderImpl builder) {
        super(builder);
        this.xssMatchSetId = builder.xssMatchSetId;
        this.changeToken = builder.changeToken;
        this.updates = builder.updates;
    }

    public String xssMatchSetId() {
        return this.xssMatchSetId;
    }

    public String changeToken() {
        return this.changeToken;
    }

    public List<XssMatchSetUpdate> updates() {
        return this.updates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.xssMatchSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.updates());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateXssMatchSetRequest)) {
            return false;
        }
        UpdateXssMatchSetRequest other = (UpdateXssMatchSetRequest)((Object)obj);
        return Objects.equals(this.xssMatchSetId(), other.xssMatchSetId()) && Objects.equals(this.changeToken(), other.changeToken()) && Objects.equals(this.updates(), other.updates());
    }

    public String toString() {
        return ToString.builder((String)"UpdateXssMatchSetRequest").add("XssMatchSetId", (Object)this.xssMatchSetId()).add("ChangeToken", (Object)this.changeToken()).add("Updates", this.updates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "XssMatchSetId": {
                return Optional.of(clazz.cast(this.xssMatchSetId()));
            }
            case "ChangeToken": {
                return Optional.of(clazz.cast(this.changeToken()));
            }
            case "Updates": {
                return Optional.of(clazz.cast(this.updates()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WAFRequest.BuilderImpl
    implements Builder {
        private String xssMatchSetId;
        private String changeToken;
        private List<XssMatchSetUpdate> updates;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateXssMatchSetRequest model) {
            super(model);
            this.xssMatchSetId(model.xssMatchSetId);
            this.changeToken(model.changeToken);
            this.updates(model.updates);
        }

        public final String getXssMatchSetId() {
            return this.xssMatchSetId;
        }

        @Override
        public final Builder xssMatchSetId(String xssMatchSetId) {
            this.xssMatchSetId = xssMatchSetId;
            return this;
        }

        public final void setXssMatchSetId(String xssMatchSetId) {
            this.xssMatchSetId = xssMatchSetId;
        }

        public final String getChangeToken() {
            return this.changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        public final Collection<XssMatchSetUpdate.Builder> getUpdates() {
            return this.updates != null ? (Collection)this.updates.stream().map(XssMatchSetUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder updates(Collection<XssMatchSetUpdate> updates) {
            this.updates = XssMatchSetUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(XssMatchSetUpdate ... updates) {
            this.updates(Arrays.asList(updates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(Consumer<XssMatchSetUpdate.Builder> ... updates) {
            this.updates(Stream.of(updates).map(c -> (XssMatchSetUpdate)((XssMatchSetUpdate.Builder)XssMatchSetUpdate.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUpdates(Collection<XssMatchSetUpdate.BuilderImpl> updates) {
            this.updates = XssMatchSetUpdatesCopier.copyFromBuilder(updates);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateXssMatchSetRequest build() {
            return new UpdateXssMatchSetRequest(this);
        }
    }

    public static interface Builder
    extends WAFRequest.Builder,
    CopyableBuilder<Builder, UpdateXssMatchSetRequest> {
        public Builder xssMatchSetId(String var1);

        public Builder changeToken(String var1);

        public Builder updates(Collection<XssMatchSetUpdate> var1);

        public Builder updates(XssMatchSetUpdate ... var1);

        public Builder updates(Consumer<XssMatchSetUpdate.Builder> ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

