/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.waf.model.WAFRequest;
import software.amazon.awssdk.services.waf.model.WafAction;
import software.amazon.awssdk.services.waf.model.WebACLUpdate;
import software.amazon.awssdk.services.waf.model.WebACLUpdatesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateWebACLRequest
extends WAFRequest
implements ToCopyableBuilder<Builder, UpdateWebACLRequest> {
    private final String webACLId;
    private final String changeToken;
    private final List<WebACLUpdate> updates;
    private final WafAction defaultAction;

    private UpdateWebACLRequest(BuilderImpl builder) {
        super(builder);
        this.webACLId = builder.webACLId;
        this.changeToken = builder.changeToken;
        this.updates = builder.updates;
        this.defaultAction = builder.defaultAction;
    }

    public String webACLId() {
        return this.webACLId;
    }

    public String changeToken() {
        return this.changeToken;
    }

    public List<WebACLUpdate> updates() {
        return this.updates;
    }

    public WafAction defaultAction() {
        return this.defaultAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.webACLId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.updates());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultAction());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWebACLRequest)) {
            return false;
        }
        UpdateWebACLRequest other = (UpdateWebACLRequest)((Object)obj);
        return Objects.equals(this.webACLId(), other.webACLId()) && Objects.equals(this.changeToken(), other.changeToken()) && Objects.equals(this.updates(), other.updates()) && Objects.equals(this.defaultAction(), other.defaultAction());
    }

    public String toString() {
        return ToString.builder((String)"UpdateWebACLRequest").add("WebACLId", (Object)this.webACLId()).add("ChangeToken", (Object)this.changeToken()).add("Updates", this.updates()).add("DefaultAction", (Object)this.defaultAction()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WebACLId": {
                return Optional.of(clazz.cast(this.webACLId()));
            }
            case "ChangeToken": {
                return Optional.of(clazz.cast(this.changeToken()));
            }
            case "Updates": {
                return Optional.of(clazz.cast(this.updates()));
            }
            case "DefaultAction": {
                return Optional.of(clazz.cast(this.defaultAction()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WAFRequest.BuilderImpl
    implements Builder {
        private String webACLId;
        private String changeToken;
        private List<WebACLUpdate> updates;
        private WafAction defaultAction;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWebACLRequest model) {
            super(model);
            this.webACLId(model.webACLId);
            this.changeToken(model.changeToken);
            this.updates(model.updates);
            this.defaultAction(model.defaultAction);
        }

        public final String getWebACLId() {
            return this.webACLId;
        }

        @Override
        public final Builder webACLId(String webACLId) {
            this.webACLId = webACLId;
            return this;
        }

        public final void setWebACLId(String webACLId) {
            this.webACLId = webACLId;
        }

        public final String getChangeToken() {
            return this.changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        public final Collection<WebACLUpdate.Builder> getUpdates() {
            return this.updates != null ? (Collection)this.updates.stream().map(WebACLUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder updates(Collection<WebACLUpdate> updates) {
            this.updates = WebACLUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(WebACLUpdate ... updates) {
            this.updates(Arrays.asList(updates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(Consumer<WebACLUpdate.Builder> ... updates) {
            this.updates(Stream.of(updates).map(c -> (WebACLUpdate)((WebACLUpdate.Builder)WebACLUpdate.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUpdates(Collection<WebACLUpdate.BuilderImpl> updates) {
            this.updates = WebACLUpdatesCopier.copyFromBuilder(updates);
        }

        public final WafAction.Builder getDefaultAction() {
            return this.defaultAction != null ? this.defaultAction.toBuilder() : null;
        }

        @Override
        public final Builder defaultAction(WafAction defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        public final void setDefaultAction(WafAction.BuilderImpl defaultAction) {
            this.defaultAction = defaultAction != null ? defaultAction.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateWebACLRequest build() {
            return new UpdateWebACLRequest(this);
        }
    }

    public static interface Builder
    extends WAFRequest.Builder,
    CopyableBuilder<Builder, UpdateWebACLRequest> {
        public Builder webACLId(String var1);

        public Builder changeToken(String var1);

        public Builder updates(Collection<WebACLUpdate> var1);

        public Builder updates(WebACLUpdate ... var1);

        public Builder updates(Consumer<WebACLUpdate.Builder> ... var1);

        public Builder defaultAction(WafAction var1);

        default public Builder defaultAction(Consumer<WafAction.Builder> defaultAction) {
            return this.defaultAction((WafAction)((WafAction.Builder)WafAction.builder().apply(defaultAction)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

