/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.FieldToMatch;
import software.amazon.awssdk.services.waf.model.TextTransformation;
import software.amazon.awssdk.services.waf.transform.RegexMatchTupleMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RegexMatchTuple
implements StructuredPojo,
ToCopyableBuilder<Builder, RegexMatchTuple> {
    private final FieldToMatch fieldToMatch;
    private final String textTransformation;
    private final String regexPatternSetId;

    private RegexMatchTuple(BuilderImpl builder) {
        this.fieldToMatch = builder.fieldToMatch;
        this.textTransformation = builder.textTransformation;
        this.regexPatternSetId = builder.regexPatternSetId;
    }

    public FieldToMatch fieldToMatch() {
        return this.fieldToMatch;
    }

    public TextTransformation textTransformation() {
        return TextTransformation.fromValue(this.textTransformation);
    }

    public String textTransformationAsString() {
        return this.textTransformation;
    }

    public String regexPatternSetId() {
        return this.regexPatternSetId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldToMatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.textTransformationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.regexPatternSetId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegexMatchTuple)) {
            return false;
        }
        RegexMatchTuple other = (RegexMatchTuple)obj;
        return Objects.equals(this.fieldToMatch(), other.fieldToMatch()) && Objects.equals(this.textTransformationAsString(), other.textTransformationAsString()) && Objects.equals(this.regexPatternSetId(), other.regexPatternSetId());
    }

    public String toString() {
        return ToString.builder((String)"RegexMatchTuple").add("FieldToMatch", (Object)this.fieldToMatch()).add("TextTransformation", (Object)this.textTransformationAsString()).add("RegexPatternSetId", (Object)this.regexPatternSetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldToMatch": {
                return Optional.of(clazz.cast(this.fieldToMatch()));
            }
            case "TextTransformation": {
                return Optional.of(clazz.cast(this.textTransformationAsString()));
            }
            case "RegexPatternSetId": {
                return Optional.of(clazz.cast(this.regexPatternSetId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RegexMatchTupleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private FieldToMatch fieldToMatch;
        private String textTransformation;
        private String regexPatternSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(RegexMatchTuple model) {
            this.fieldToMatch(model.fieldToMatch);
            this.textTransformation(model.textTransformation);
            this.regexPatternSetId(model.regexPatternSetId);
        }

        public final FieldToMatch.Builder getFieldToMatch() {
            return this.fieldToMatch != null ? this.fieldToMatch.toBuilder() : null;
        }

        @Override
        public final Builder fieldToMatch(FieldToMatch fieldToMatch) {
            this.fieldToMatch = fieldToMatch;
            return this;
        }

        public final void setFieldToMatch(FieldToMatch.BuilderImpl fieldToMatch) {
            this.fieldToMatch = fieldToMatch != null ? fieldToMatch.build() : null;
        }

        public final String getTextTransformation() {
            return this.textTransformation;
        }

        @Override
        public final Builder textTransformation(String textTransformation) {
            this.textTransformation = textTransformation;
            return this;
        }

        @Override
        public final Builder textTransformation(TextTransformation textTransformation) {
            this.textTransformation(textTransformation.toString());
            return this;
        }

        public final void setTextTransformation(String textTransformation) {
            this.textTransformation = textTransformation;
        }

        public final String getRegexPatternSetId() {
            return this.regexPatternSetId;
        }

        @Override
        public final Builder regexPatternSetId(String regexPatternSetId) {
            this.regexPatternSetId = regexPatternSetId;
            return this;
        }

        public final void setRegexPatternSetId(String regexPatternSetId) {
            this.regexPatternSetId = regexPatternSetId;
        }

        public RegexMatchTuple build() {
            return new RegexMatchTuple(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RegexMatchTuple> {
        public Builder fieldToMatch(FieldToMatch var1);

        default public Builder fieldToMatch(Consumer<FieldToMatch.Builder> fieldToMatch) {
            return this.fieldToMatch((FieldToMatch)((FieldToMatch.Builder)FieldToMatch.builder().apply(fieldToMatch)).build());
        }

        public Builder textTransformation(String var1);

        public Builder textTransformation(TextTransformation var1);

        public Builder regexPatternSetId(String var1);
    }
}

