/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.waf.model.SizeConstraintSetSummariesCopier;
import software.amazon.awssdk.services.waf.model.SizeConstraintSetSummary;
import software.amazon.awssdk.services.waf.model.WAFResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListSizeConstraintSetsResponse
extends WAFResponse
implements ToCopyableBuilder<Builder, ListSizeConstraintSetsResponse> {
    private final String nextMarker;
    private final List<SizeConstraintSetSummary> sizeConstraintSets;

    private ListSizeConstraintSetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.sizeConstraintSets = builder.sizeConstraintSets;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public List<SizeConstraintSetSummary> sizeConstraintSets() {
        return this.sizeConstraintSets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeConstraintSets());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSizeConstraintSetsResponse)) {
            return false;
        }
        ListSizeConstraintSetsResponse other = (ListSizeConstraintSetsResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && Objects.equals(this.sizeConstraintSets(), other.sizeConstraintSets());
    }

    public String toString() {
        return ToString.builder((String)"ListSizeConstraintSetsResponse").add("NextMarker", (Object)this.nextMarker()).add("SizeConstraintSets", this.sizeConstraintSets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.of(clazz.cast(this.nextMarker()));
            }
            case "SizeConstraintSets": {
                return Optional.of(clazz.cast(this.sizeConstraintSets()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WAFResponse.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<SizeConstraintSetSummary> sizeConstraintSets;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSizeConstraintSetsResponse model) {
            super(model);
            this.nextMarker(model.nextMarker);
            this.sizeConstraintSets(model.sizeConstraintSets);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<SizeConstraintSetSummary.Builder> getSizeConstraintSets() {
            return this.sizeConstraintSets != null ? (Collection)this.sizeConstraintSets.stream().map(SizeConstraintSetSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sizeConstraintSets(Collection<SizeConstraintSetSummary> sizeConstraintSets) {
            this.sizeConstraintSets = SizeConstraintSetSummariesCopier.copy(sizeConstraintSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sizeConstraintSets(SizeConstraintSetSummary ... sizeConstraintSets) {
            this.sizeConstraintSets(Arrays.asList(sizeConstraintSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sizeConstraintSets(Consumer<SizeConstraintSetSummary.Builder> ... sizeConstraintSets) {
            this.sizeConstraintSets(Stream.of(sizeConstraintSets).map(c -> (SizeConstraintSetSummary)((SizeConstraintSetSummary.Builder)SizeConstraintSetSummary.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSizeConstraintSets(Collection<SizeConstraintSetSummary.BuilderImpl> sizeConstraintSets) {
            this.sizeConstraintSets = SizeConstraintSetSummariesCopier.copyFromBuilder(sizeConstraintSets);
        }

        @Override
        public ListSizeConstraintSetsResponse build() {
            return new ListSizeConstraintSetsResponse(this);
        }
    }

    public static interface Builder
    extends WAFResponse.Builder,
    CopyableBuilder<Builder, ListSizeConstraintSetsResponse> {
        public Builder nextMarker(String var1);

        public Builder sizeConstraintSets(Collection<SizeConstraintSetSummary> var1);

        public Builder sizeConstraintSets(SizeConstraintSetSummary ... var1);

        public Builder sizeConstraintSets(Consumer<SizeConstraintSetSummary.Builder> ... var1);
    }
}

