/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.GeoMatchConstraint;
import software.amazon.awssdk.services.waf.model.GeoMatchConstraintsCopier;
import software.amazon.awssdk.services.waf.transform.GeoMatchSetMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GeoMatchSet
implements StructuredPojo,
ToCopyableBuilder<Builder, GeoMatchSet> {
    private final String geoMatchSetId;
    private final String name;
    private final List<GeoMatchConstraint> geoMatchConstraints;

    private GeoMatchSet(BuilderImpl builder) {
        this.geoMatchSetId = builder.geoMatchSetId;
        this.name = builder.name;
        this.geoMatchConstraints = builder.geoMatchConstraints;
    }

    public String geoMatchSetId() {
        return this.geoMatchSetId;
    }

    public String name() {
        return this.name;
    }

    public List<GeoMatchConstraint> geoMatchConstraints() {
        return this.geoMatchConstraints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.geoMatchSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.geoMatchConstraints());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoMatchSet)) {
            return false;
        }
        GeoMatchSet other = (GeoMatchSet)obj;
        return Objects.equals(this.geoMatchSetId(), other.geoMatchSetId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.geoMatchConstraints(), other.geoMatchConstraints());
    }

    public String toString() {
        return ToString.builder((String)"GeoMatchSet").add("GeoMatchSetId", (Object)this.geoMatchSetId()).add("Name", (Object)this.name()).add("GeoMatchConstraints", this.geoMatchConstraints()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GeoMatchSetId": {
                return Optional.of(clazz.cast(this.geoMatchSetId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "GeoMatchConstraints": {
                return Optional.of(clazz.cast(this.geoMatchConstraints()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GeoMatchSetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String geoMatchSetId;
        private String name;
        private List<GeoMatchConstraint> geoMatchConstraints;

        private BuilderImpl() {
        }

        private BuilderImpl(GeoMatchSet model) {
            this.geoMatchSetId(model.geoMatchSetId);
            this.name(model.name);
            this.geoMatchConstraints(model.geoMatchConstraints);
        }

        public final String getGeoMatchSetId() {
            return this.geoMatchSetId;
        }

        @Override
        public final Builder geoMatchSetId(String geoMatchSetId) {
            this.geoMatchSetId = geoMatchSetId;
            return this;
        }

        public final void setGeoMatchSetId(String geoMatchSetId) {
            this.geoMatchSetId = geoMatchSetId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<GeoMatchConstraint.Builder> getGeoMatchConstraints() {
            return this.geoMatchConstraints != null ? (Collection)this.geoMatchConstraints.stream().map(GeoMatchConstraint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder geoMatchConstraints(Collection<GeoMatchConstraint> geoMatchConstraints) {
            this.geoMatchConstraints = GeoMatchConstraintsCopier.copy(geoMatchConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder geoMatchConstraints(GeoMatchConstraint ... geoMatchConstraints) {
            this.geoMatchConstraints(Arrays.asList(geoMatchConstraints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder geoMatchConstraints(Consumer<GeoMatchConstraint.Builder> ... geoMatchConstraints) {
            this.geoMatchConstraints(Stream.of(geoMatchConstraints).map(c -> (GeoMatchConstraint)((GeoMatchConstraint.Builder)GeoMatchConstraint.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGeoMatchConstraints(Collection<GeoMatchConstraint.BuilderImpl> geoMatchConstraints) {
            this.geoMatchConstraints = GeoMatchConstraintsCopier.copyFromBuilder(geoMatchConstraints);
        }

        public GeoMatchSet build() {
            return new GeoMatchSet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GeoMatchSet> {
        public Builder geoMatchSetId(String var1);

        public Builder name(String var1);

        public Builder geoMatchConstraints(Collection<GeoMatchConstraint> var1);

        public Builder geoMatchConstraints(GeoMatchConstraint ... var1);

        public Builder geoMatchConstraints(Consumer<GeoMatchConstraint.Builder> ... var1);
    }
}

