/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.waf.model.HTTPRequest;
import software.amazon.awssdk.services.waf.transform.HTTPHeaderUnmarshaller;

public class HTTPRequestUnmarshaller
implements Unmarshaller<HTTPRequest, JsonUnmarshallerContext> {
    private static HTTPRequestUnmarshaller INSTANCE;

    public HTTPRequest unmarshall(JsonUnmarshallerContext context) throws Exception {
        HTTPRequest.Builder httpRequestBuilder = HTTPRequest.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ClientIP", targetDepth)) {
                    context.nextToken();
                    httpRequestBuilder.clientIP((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Country", targetDepth)) {
                    context.nextToken();
                    httpRequestBuilder.country((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("URI", targetDepth)) {
                    context.nextToken();
                    httpRequestBuilder.uri((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Method", targetDepth)) {
                    context.nextToken();
                    httpRequestBuilder.method((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("HTTPVersion", targetDepth)) {
                    context.nextToken();
                    httpRequestBuilder.httpVersion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Headers", targetDepth)) {
                    context.nextToken();
                    httpRequestBuilder.headers(new ListUnmarshaller((Unmarshaller)HTTPHeaderUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (HTTPRequest)httpRequestBuilder.build();
    }

    public static HTTPRequestUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HTTPRequestUnmarshaller();
        }
        return INSTANCE;
    }
}

