/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.waf.model.RuleSummariesCopier;
import software.amazon.awssdk.services.waf.model.RuleSummary;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListRateBasedRulesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListRateBasedRulesResponse> {
    private final String nextMarker;
    private final List<RuleSummary> rules;

    private ListRateBasedRulesResponse(BuilderImpl builder) {
        this.nextMarker = builder.nextMarker;
        this.rules = builder.rules;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public List<RuleSummary> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        hashCode = 31 * hashCode + (this.rules() == null ? 0 : this.rules().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRateBasedRulesResponse)) {
            return false;
        }
        ListRateBasedRulesResponse other = (ListRateBasedRulesResponse)((Object)obj);
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        if (other.nextMarker() != null && !other.nextMarker().equals(this.nextMarker())) {
            return false;
        }
        if (other.rules() == null ^ this.rules() == null) {
            return false;
        }
        return other.rules() == null || other.rules().equals(this.rules());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (this.rules() != null) {
            sb.append("Rules: ").append(this.rules()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<RuleSummary> rules;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRateBasedRulesResponse model) {
            this.setNextMarker(model.nextMarker);
            this.setRules(model.rules);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<RuleSummary> getRules() {
            return this.rules;
        }

        @Override
        public final Builder rules(Collection<RuleSummary> rules) {
            this.rules = RuleSummariesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(RuleSummary ... rules) {
            if (this.rules == null) {
                this.rules = new ArrayList<RuleSummary>(rules.length);
            }
            for (RuleSummary e : rules) {
                this.rules.add(e);
            }
            return this;
        }

        public final void setRules(Collection<RuleSummary> rules) {
            this.rules = RuleSummariesCopier.copy(rules);
        }

        @SafeVarargs
        public final void setRules(RuleSummary ... rules) {
            if (this.rules == null) {
                this.rules = new ArrayList<RuleSummary>(rules.length);
            }
            for (RuleSummary e : rules) {
                this.rules.add(e);
            }
        }

        public ListRateBasedRulesResponse build() {
            return new ListRateBasedRulesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListRateBasedRulesResponse> {
        public Builder nextMarker(String var1);

        public Builder rules(Collection<RuleSummary> var1);

        public Builder rules(RuleSummary ... var1);
    }
}

