/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.transform.IPSetSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class IPSetSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, IPSetSummary> {
    private final String ipSetId;
    private final String name;

    private IPSetSummary(BuilderImpl builder) {
        this.ipSetId = builder.ipSetId;
        this.name = builder.name;
    }

    public String ipSetId() {
        return this.ipSetId;
    }

    public String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ipSetId() == null ? 0 : this.ipSetId().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPSetSummary)) {
            return false;
        }
        IPSetSummary other = (IPSetSummary)obj;
        if (other.ipSetId() == null ^ this.ipSetId() == null) {
            return false;
        }
        if (other.ipSetId() != null && !other.ipSetId().equals(this.ipSetId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        return other.name() == null || other.name().equals(this.name());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ipSetId() != null) {
            sb.append("IPSetId: ").append(this.ipSetId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IPSetSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String ipSetId;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(IPSetSummary model) {
            this.setIPSetId(model.ipSetId);
            this.setName(model.name);
        }

        public final String getIPSetId() {
            return this.ipSetId;
        }

        @Override
        public final Builder ipSetId(String ipSetId) {
            this.ipSetId = ipSetId;
            return this;
        }

        public final void setIPSetId(String ipSetId) {
            this.ipSetId = ipSetId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public IPSetSummary build() {
            return new IPSetSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IPSetSummary> {
        public Builder ipSetId(String var1);

        public Builder name(String var1);
    }
}

