/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.vpclattice.model.VpcLatticeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourceEndpointAssociationsRequest
extends VpcLatticeRequest
implements ToCopyableBuilder<Builder, ListResourceEndpointAssociationsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListResourceEndpointAssociationsRequest.getter(ListResourceEndpointAssociationsRequest::maxResults)).setter(ListResourceEndpointAssociationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListResourceEndpointAssociationsRequest.getter(ListResourceEndpointAssociationsRequest::nextToken)).setter(ListResourceEndpointAssociationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> RESOURCE_CONFIGURATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceConfigurationIdentifier").getter(ListResourceEndpointAssociationsRequest.getter(ListResourceEndpointAssociationsRequest::resourceConfigurationIdentifier)).setter(ListResourceEndpointAssociationsRequest.setter(Builder::resourceConfigurationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceConfigurationIdentifier").build()}).build();
    private static final SdkField<String> RESOURCE_ENDPOINT_ASSOCIATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceEndpointAssociationIdentifier").getter(ListResourceEndpointAssociationsRequest.getter(ListResourceEndpointAssociationsRequest::resourceEndpointAssociationIdentifier)).setter(ListResourceEndpointAssociationsRequest.setter(Builder::resourceEndpointAssociationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceEndpointAssociationIdentifier").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vpcEndpointId").getter(ListResourceEndpointAssociationsRequest.getter(ListResourceEndpointAssociationsRequest::vpcEndpointId)).setter(ListResourceEndpointAssociationsRequest.setter(Builder::vpcEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("vpcEndpointId").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vpcEndpointOwner").getter(ListResourceEndpointAssociationsRequest.getter(ListResourceEndpointAssociationsRequest::vpcEndpointOwner)).setter(ListResourceEndpointAssociationsRequest.setter(Builder::vpcEndpointOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("vpcEndpointOwner").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, RESOURCE_CONFIGURATION_IDENTIFIER_FIELD, RESOURCE_ENDPOINT_ASSOCIATION_IDENTIFIER_FIELD, VPC_ENDPOINT_ID_FIELD, VPC_ENDPOINT_OWNER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListResourceEndpointAssociationsRequest.memberNameToFieldInitializer();
    private final Integer maxResults;
    private final String nextToken;
    private final String resourceConfigurationIdentifier;
    private final String resourceEndpointAssociationIdentifier;
    private final String vpcEndpointId;
    private final String vpcEndpointOwner;

    private ListResourceEndpointAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.resourceConfigurationIdentifier = builder.resourceConfigurationIdentifier;
        this.resourceEndpointAssociationIdentifier = builder.resourceEndpointAssociationIdentifier;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.vpcEndpointOwner = builder.vpcEndpointOwner;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String resourceConfigurationIdentifier() {
        return this.resourceConfigurationIdentifier;
    }

    public final String resourceEndpointAssociationIdentifier() {
        return this.resourceEndpointAssociationIdentifier;
    }

    public final String vpcEndpointId() {
        return this.vpcEndpointId;
    }

    public final String vpcEndpointOwner() {
        return this.vpcEndpointOwner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfigurationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceEndpointAssociationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointOwner());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceEndpointAssociationsRequest)) {
            return false;
        }
        ListResourceEndpointAssociationsRequest other = (ListResourceEndpointAssociationsRequest)((Object)obj);
        return Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.resourceConfigurationIdentifier(), other.resourceConfigurationIdentifier()) && Objects.equals(this.resourceEndpointAssociationIdentifier(), other.resourceEndpointAssociationIdentifier()) && Objects.equals(this.vpcEndpointId(), other.vpcEndpointId()) && Objects.equals(this.vpcEndpointOwner(), other.vpcEndpointOwner());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourceEndpointAssociationsRequest").add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("ResourceConfigurationIdentifier", (Object)this.resourceConfigurationIdentifier()).add("ResourceEndpointAssociationIdentifier", (Object)this.resourceEndpointAssociationIdentifier()).add("VpcEndpointId", (Object)this.vpcEndpointId()).add("VpcEndpointOwner", (Object)this.vpcEndpointOwner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "resourceConfigurationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceConfigurationIdentifier()));
            }
            case "resourceEndpointAssociationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceEndpointAssociationIdentifier()));
            }
            case "vpcEndpointId": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointId()));
            }
            case "vpcEndpointOwner": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointOwner()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("resourceConfigurationIdentifier", RESOURCE_CONFIGURATION_IDENTIFIER_FIELD);
        map.put("resourceEndpointAssociationIdentifier", RESOURCE_ENDPOINT_ASSOCIATION_IDENTIFIER_FIELD);
        map.put("vpcEndpointId", VPC_ENDPOINT_ID_FIELD);
        map.put("vpcEndpointOwner", VPC_ENDPOINT_OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListResourceEndpointAssociationsRequest, T> g) {
        return obj -> g.apply((ListResourceEndpointAssociationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VpcLatticeRequest.BuilderImpl
    implements Builder {
        private Integer maxResults;
        private String nextToken;
        private String resourceConfigurationIdentifier;
        private String resourceEndpointAssociationIdentifier;
        private String vpcEndpointId;
        private String vpcEndpointOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceEndpointAssociationsRequest model) {
            super(model);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.resourceConfigurationIdentifier(model.resourceConfigurationIdentifier);
            this.resourceEndpointAssociationIdentifier(model.resourceEndpointAssociationIdentifier);
            this.vpcEndpointId(model.vpcEndpointId);
            this.vpcEndpointOwner(model.vpcEndpointOwner);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getResourceConfigurationIdentifier() {
            return this.resourceConfigurationIdentifier;
        }

        public final void setResourceConfigurationIdentifier(String resourceConfigurationIdentifier) {
            this.resourceConfigurationIdentifier = resourceConfigurationIdentifier;
        }

        @Override
        public final Builder resourceConfigurationIdentifier(String resourceConfigurationIdentifier) {
            this.resourceConfigurationIdentifier = resourceConfigurationIdentifier;
            return this;
        }

        public final String getResourceEndpointAssociationIdentifier() {
            return this.resourceEndpointAssociationIdentifier;
        }

        public final void setResourceEndpointAssociationIdentifier(String resourceEndpointAssociationIdentifier) {
            this.resourceEndpointAssociationIdentifier = resourceEndpointAssociationIdentifier;
        }

        @Override
        public final Builder resourceEndpointAssociationIdentifier(String resourceEndpointAssociationIdentifier) {
            this.resourceEndpointAssociationIdentifier = resourceEndpointAssociationIdentifier;
            return this;
        }

        public final String getVpcEndpointId() {
            return this.vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final String getVpcEndpointOwner() {
            return this.vpcEndpointOwner;
        }

        public final void setVpcEndpointOwner(String vpcEndpointOwner) {
            this.vpcEndpointOwner = vpcEndpointOwner;
        }

        @Override
        public final Builder vpcEndpointOwner(String vpcEndpointOwner) {
            this.vpcEndpointOwner = vpcEndpointOwner;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListResourceEndpointAssociationsRequest build() {
            return new ListResourceEndpointAssociationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends VpcLatticeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourceEndpointAssociationsRequest> {
        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder resourceConfigurationIdentifier(String var1);

        public Builder resourceEndpointAssociationIdentifier(String var1);

        public Builder vpcEndpointId(String var1);

        public Builder vpcEndpointOwner(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

